/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.codegen.AddShapes;
import software.amazon.awssdk.codegen.IntermediateModelBuilder;
import software.amazon.awssdk.codegen.IntermediateModelShapeProcessor;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.model.intermediate.ShapeUnmarshaller;
import software.amazon.awssdk.codegen.model.service.Shape;

final class AddModelShapes
extends AddShapes
implements IntermediateModelShapeProcessor {
    AddModelShapes(IntermediateModelBuilder builder) {
        super(builder);
    }

    @Override
    public Map<String, ShapeModel> process(Map<String, OperationModel> currentOperations, Map<String, ShapeModel> currentShapes) {
        return this.constructModelShapes(currentShapes.keySet());
    }

    private Map<String, ShapeModel> constructModelShapes(Set<String> shapesToSkip) {
        HashMap<String, ShapeModel> javaShapes = new HashMap<String, ShapeModel>();
        for (Map.Entry<String, Shape> entry : this.getServiceModel().getShapes().entrySet()) {
            String javaClassName;
            String shapeName = entry.getKey();
            Shape shape = entry.getValue();
            ShapeType shapeType = this.getModelShapeType(shape);
            if (shapeType == null || shapesToSkip.contains(javaClassName = this.getNamingStrategy().getShapeClassName(shapeName))) continue;
            ShapeModel modelShape = this.generateShapeModel(javaClassName, shapeName);
            modelShape.setType(shapeType);
            ShapeUnmarshaller unmarshaller = new ShapeUnmarshaller();
            unmarshaller.setFlattened(shape.isFlattened());
            modelShape.setUnmarshaller(unmarshaller);
            javaShapes.put(javaClassName, modelShape);
        }
        return javaShapes;
    }

    private ShapeType getModelShapeType(Shape shape) {
        if (shape.isException()) {
            return null;
        }
        if (Utils.isStructure(shape)) {
            return ShapeType.Model;
        }
        if (shape.getEnumValues() != null) {
            return ShapeType.Enum;
        }
        return null;
    }
}

