/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.common;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.util.VersionInfo;

public class UserAgentUtilsSpec
implements ClassSpec {
    private static final String PAGINATOR_USER_AGENT = "PAGINATED";
    protected final IntermediateModel model;
    protected final PoetExtension poetExtensions;

    public UserAgentUtilsSpec(IntermediateModel model) {
        this.model = model;
        this.poetExtensions = new PoetExtension(model);
    }

    @Override
    public TypeSpec poetSpec() {
        return TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(PoetUtils.generatedAnnotation()).addAnnotation(SdkInternalApi.class).addMethod(this.privateConstructor()).addMethod(this.applyUserAgentInfoMethod()).addMethod(this.applyPaginatorUserAgentMethod()).build();
    }

    @Override
    public ClassName className() {
        return this.poetExtensions.getUserAgentClass();
    }

    protected MethodSpec privateConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private MethodSpec applyUserAgentInfoMethod() {
        TypeVariableName typeVariableName = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{this.poetExtensions.getModelClass(this.model.getSdkRequestBaseClassName())});
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{ClassName.get(AwsRequestOverrideConfiguration.Builder.class)});
        CodeBlock codeBlock = CodeBlock.builder().addStatement("$T overrideConfiguration =\n            request.overrideConfiguration().map(c -> c.toBuilder().applyMutation(userAgentApplier).build())\n            .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()))", new Object[]{AwsRequestOverrideConfiguration.class}).addStatement("return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build()", new Object[0]).build();
        return MethodSpec.methodBuilder((String)"applyUserAgentInfo").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)typeVariableName, "request", new Modifier[0]).addParameter((TypeName)parameterizedTypeName, "userAgentApplier", new Modifier[0]).addTypeVariable(typeVariableName).addCode(codeBlock).returns((TypeName)typeVariableName).build();
    }

    private MethodSpec applyPaginatorUserAgentMethod() {
        TypeVariableName typeVariableName = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{this.poetExtensions.getModelClass(this.model.getSdkRequestBaseClassName())});
        return MethodSpec.methodBuilder((String)"applyPaginatorUserAgent").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)typeVariableName, "request", new Modifier[0]).addTypeVariable(typeVariableName).addStatement("return applyUserAgentInfo(request, b -> b.addApiName($T.builder().version($T.SDK_VERSION).name($S).build()))", new Object[]{ApiName.class, VersionInfo.class, PAGINATOR_USER_AGENT}).returns((TypeName)typeVariableName).build();
    }
}

