/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.model.ServiceClientConfigurationUtils;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.utils.Validate;

public class ServiceClientConfigurationBuilderClass
implements ClassSpec {
    private final ServiceClientConfigurationUtils utils;
    private final ClassName builderInterface;

    public ServiceClientConfigurationBuilderClass(IntermediateModel model) {
        this.utils = new ServiceClientConfigurationUtils(model);
        this.builderInterface = this.utils.serviceClientConfigurationClassName().nestedClass("Builder");
    }

    @Override
    public ClassName className() {
        return this.utils.serviceClientConfigurationBuilderClassName();
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(SdkInternalApi.class);
        return builder.addMethod(this.builderMethod()).addMethod(this.builderFromSdkClientConfiguration()).addType(this.builderInternalSpec()).addType(this.builderImplSpec()).build();
    }

    private MethodSpec builderFromSdkClientConfiguration() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(SdkClientConfiguration.Builder.class, "builder", new Modifier[0]).returns((TypeName)this.className().nestedClass("BuilderInternal")).addStatement("return new BuilderImpl(builder)", new Object[0]).build();
    }

    private MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.builderInterface).addStatement("return new BuilderImpl()", new Object[0]).build();
    }

    private TypeSpec builderInternalSpec() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)"BuilderInternal").addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)this.builderInterface);
        builder.addMethod(MethodSpec.methodBuilder((String)"buildSdkClientConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(SdkClientConfiguration.class).build());
        return builder.build();
    }

    private TypeSpec builderImplSpec() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"BuilderImpl").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterface((TypeName)this.className().nestedClass("BuilderInternal"));
        builder.addField(SdkClientConfiguration.Builder.class, "internalBuilder", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("this.internalBuilder = $T.builder()", new Object[]{SdkClientConfiguration.class}).build());
        builder.addMethod(this.constructorFromSdkClientConfiguration());
        for (ServiceClientConfigurationUtils.Field field : this.utils.serviceClientConfigurationFields()) {
            this.addLocalFieldForBuilderIfNeeded(field, builder);
            builder.addMethod(this.setterForField(field));
            builder.addMethod(this.getterForBuilderField(field));
        }
        builder.addMethod(MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.utils.serviceClientConfigurationClassName()).addStatement("return new $T(this)", new Object[]{this.utils.serviceClientConfigurationClassName()}).build());
        builder.addMethod(this.buildSdkClientConfigurationMethod());
        return builder.build();
    }

    private MethodSpec buildSdkClientConfigurationMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"buildSdkClientConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(SdkClientConfiguration.class);
        for (ServiceClientConfigurationUtils.Field field : this.utils.serviceClientConfigurationFields()) {
            CodeBlock block;
            if (field.optionClass() != null || (block = field.copyToConfiguration()) == null) continue;
            builder.addCode(block);
        }
        return builder.addStatement("return internalBuilder.build()", new Object[0]).build();
    }

    private MethodSpec constructorFromSdkClientConfiguration() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(SdkClientConfiguration.Builder.class, "internalBuilder", new Modifier[0]).addStatement("this.internalBuilder = internalBuilder", new Object[0]);
        for (ServiceClientConfigurationUtils.Field field : this.utils.serviceClientConfigurationFields()) {
            CodeBlock block;
            if (field.optionClass() != null || (block = field.constructFromConfiguration()) == null) continue;
            builder.addCode(block);
        }
        return builder.build();
    }

    private void addLocalFieldForBuilderIfNeeded(ServiceClientConfigurationUtils.Field field, TypeSpec.Builder builder) {
        if (field.optionClass() == null) {
            builder.addField(field.type(), field.name(), new Modifier[]{Modifier.PRIVATE});
        }
    }

    private MethodSpec setterForField(ServiceClientConfigurationUtils.Field field) {
        MethodSpec fieldBuilderSetter = field.builderSetterImpl();
        if (fieldBuilderSetter != null) {
            return fieldBuilderSetter.toBuilder().returns((TypeName)this.builderInterface).build();
        }
        MethodSpec.Builder builder = this.baseSetterForField(field);
        if (field.isLocalField()) {
            builder.addAnnotation(Override.class);
        }
        if (field.optionClass() == null) {
            return builder.addStatement("this.$1L = $1L", new Object[]{field.name()}).addStatement("return this", new Object[0]).build();
        }
        return builder.addStatement("internalBuilder.option($T.$L, $L)", new Object[]{field.optionClass(), field.optionName(), field.name()}).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec.Builder baseSetterForField(ServiceClientConfigurationUtils.Field field) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)field.name()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(field.type(), field.name(), new Modifier[0]).addJavadoc("Sets the value for " + field.doc(), new Object[0]).returns((TypeName)this.builderInterface);
        if (!field.isLocalField()) {
            builder.addAnnotation(Override.class);
        }
        return builder;
    }

    private MethodSpec getterForBuilderField(ServiceClientConfigurationUtils.Field field) {
        return this.getterForField(field, "internalBuilder", false);
    }

    private MethodSpec getterForField(ServiceClientConfigurationUtils.Field field, String fieldName, boolean forDataGetter) {
        MethodSpec fieldBuilderGetter = field.builderGetterImpl();
        if (fieldBuilderGetter != null) {
            return fieldBuilderGetter.toBuilder().returns(field.type()).build();
        }
        MethodSpec.Builder builder = this.baseGetterForField(field);
        if (!forDataGetter && field.isLocalField()) {
            builder.addAnnotation(Override.class);
        }
        if (forDataGetter && field.isLocalField()) {
            return builder.addStatement("return $L", new Object[]{field.name()}).build();
        }
        if (field.optionClass() == null) {
            return builder.addStatement("return $L", new Object[]{field.name()}).build();
        }
        if (field.baseType() != null) {
            return builder.addStatement("$T result = $L.option($T.$L)", new Object[]{field.baseType(), fieldName, field.optionClass(), field.optionName()}).beginControlFlow("if (result == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $T.isInstanceOf($T.class, result, $S + $T.class.getSimpleName())", new Object[]{Validate.class, field.type(), "Expected an instance of ", field.type()}).build();
        }
        return builder.addStatement("return $L.option($T.$L)", new Object[]{fieldName, field.optionClass(), field.optionName()}).build();
    }

    private MethodSpec.Builder baseGetterForField(ServiceClientConfigurationUtils.Field field) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)field.name()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Gets the value for " + field.doc(), new Object[0]).returns(field.type());
        if (!field.isLocalField()) {
            builder.addAnnotation(Override.class);
        }
        return builder;
    }
}

