/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeCodegenMetadata;
import software.amazon.awssdk.codegen.utils.AuthUtils;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4aAuthScheme;
import software.amazon.awssdk.http.auth.scheme.NoAuthAuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;

public final class AuthSchemeSpecUtils {
    private static final Set<String> DEFAULT_AUTH_SCHEME_PARAMS = Collections.unmodifiableSet(AuthSchemeSpecUtils.setOf("region", "operation"));
    private final IntermediateModel intermediateModel;
    private final boolean useSraAuth;
    private final Set<String> allowedEndpointAuthSchemeParams;
    private final boolean allowedEndpointAuthSchemeParamsConfigured;

    public AuthSchemeSpecUtils(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        CustomizationConfig customization = intermediateModel.getCustomizationConfig();
        this.useSraAuth = customization.useSraAuth();
        if (customization.getAllowedEndpointAuthSchemeParamsConfigured()) {
            this.allowedEndpointAuthSchemeParams = Collections.unmodifiableSet(new HashSet<String>(customization.getAllowedEndpointAuthSchemeParams()));
            this.allowedEndpointAuthSchemeParamsConfigured = true;
        } else {
            this.allowedEndpointAuthSchemeParams = Collections.emptySet();
            this.allowedEndpointAuthSchemeParamsConfigured = false;
        }
    }

    public boolean useSraAuth() {
        return this.useSraAuth;
    }

    private String basePackage() {
        return this.intermediateModel.getMetadata().getFullAuthSchemePackageName();
    }

    private String internalPackage() {
        return this.intermediateModel.getMetadata().getFullInternalAuthSchemePackageName();
    }

    public ClassName parametersInterfaceName() {
        return ClassName.get((String)this.basePackage(), (String)(this.intermediateModel.getMetadata().getServiceName() + "AuthSchemeParams"), (String[])new String[0]);
    }

    public ClassName parametersInterfaceBuilderInterfaceName() {
        return this.parametersInterfaceName().nestedClass("Builder");
    }

    public ClassName parametersDefaultImplName() {
        return ClassName.get((String)this.internalPackage(), (String)("Default" + this.parametersInterfaceName().simpleName()), (String[])new String[0]);
    }

    public ClassName parametersDefaultBuilderImplName() {
        return ClassName.get((String)this.internalPackage(), (String)("Default" + this.parametersInterfaceName().simpleName()), (String[])new String[0]);
    }

    public ClassName providerInterfaceName() {
        return ClassName.get((String)this.basePackage(), (String)(this.intermediateModel.getMetadata().getServiceName() + "AuthSchemeProvider"), (String[])new String[0]);
    }

    public ClassName defaultAuthSchemeProviderName() {
        return ClassName.get((String)this.internalPackage(), (String)("Default" + this.providerInterfaceName().simpleName()), (String[])new String[0]);
    }

    public ClassName modeledAuthSchemeProviderName() {
        return ClassName.get((String)this.internalPackage(), (String)("Modeled" + this.providerInterfaceName().simpleName()), (String[])new String[0]);
    }

    public ClassName authSchemeInterceptor() {
        return ClassName.get((String)this.internalPackage(), (String)(this.intermediateModel.getMetadata().getServiceName() + "AuthSchemeInterceptor"), (String[])new String[0]);
    }

    public TypeName resolverReturnType() {
        return ParameterizedTypeName.get(List.class, (Type[])new Type[]{AuthSchemeOption.class});
    }

    public boolean usesSigV4() {
        return AuthUtils.usesAwsAuth(this.intermediateModel);
    }

    public boolean useEndpointBasedAuthProvider() {
        return this.generateEndpointBasedParams();
    }

    public String paramMethodName(String name) {
        return this.intermediateModel.getNamingStrategy().getVariableName(name);
    }

    public boolean generateEndpointBasedParams() {
        return this.intermediateModel.getCustomizationConfig().isEnableEndpointAuthSchemeParams();
    }

    public boolean includeParam(String name) {
        if (this.allowedEndpointAuthSchemeParamsConfigured) {
            return this.allowedEndpointAuthSchemeParams.contains(name);
        }
        return !DEFAULT_AUTH_SCHEME_PARAMS.contains(name.toLowerCase(Locale.US));
    }

    public boolean includeParamForProvider(String name) {
        if (this.allowedEndpointAuthSchemeParamsConfigured) {
            if (DEFAULT_AUTH_SCHEME_PARAMS.contains(name.toLowerCase(Locale.US))) {
                return true;
            }
            return this.allowedEndpointAuthSchemeParams.contains(name);
        }
        return true;
    }

    public String serviceName() {
        return this.intermediateModel.getMetadata().getServiceName();
    }

    public String signingName() {
        return this.intermediateModel.getMetadata().getSigningName();
    }

    public Map<List<String>, List<AuthType>> operationsToAuthType() {
        Map authSchemesToOperations = this.intermediateModel.getOperations().entrySet().stream().filter(kvp -> !((OperationModel)kvp.getValue()).getAuth().isEmpty()).collect(Collectors.groupingBy(kvp -> ((OperationModel)kvp.getValue()).getAuth(), Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        Map operationsToAuthType = authSchemesToOperations.entrySet().stream().sorted(Comparator.comparing(left -> (String)((List)left.getValue()).get(0))).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (a, b) -> b, LinkedHashMap::new));
        List<AuthType> serviceDefaults = this.serviceDefaultAuthTypes();
        List operationsWithDefaults = authSchemesToOperations.remove(serviceDefaults);
        operationsToAuthType.remove(operationsWithDefaults);
        operationsToAuthType.put(Collections.emptyList(), serviceDefaults);
        return operationsToAuthType;
    }

    public List<AuthType> serviceDefaultAuthTypes() {
        List<AuthType> modeled = this.intermediateModel.getMetadata().getAuth();
        if (!modeled.isEmpty()) {
            return modeled;
        }
        return Collections.singletonList(this.intermediateModel.getMetadata().getAuthType());
    }

    public Set<Class<?>> allServiceConcreteAuthSchemeClasses() {
        Set result = Stream.concat(this.intermediateModel.getOperations().values().stream().map(OperationModel::getAuth).flatMap(Collection::stream), this.intermediateModel.getMetadata().getAuth().stream()).map(AuthSchemeCodegenMetadata::fromAuthType).map(AuthSchemeCodegenMetadata::authSchemeClass).collect(Collectors.toCollection(() -> new TreeSet<Class>(Comparator.comparing(Class::getSimpleName))));
        if (this.useEndpointBasedAuthProvider()) {
            result.add(AwsV4aAuthScheme.class);
        }
        result.add(NoAuthAuthScheme.class);
        return result;
    }

    private static Set<String> setOf(String v1, String v2) {
        HashSet<String> set = new HashSet<String>();
        set.add(v1);
        set.add(v2);
        return set;
    }
}

