/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.internal.Constant;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.utils.StringUtils;

public final class DeprecationUtils {
    private static final AnnotationSpec DEPRECATED = AnnotationSpec.builder(Deprecated.class).build();

    private DeprecationUtils() {
    }

    public static MethodSpec checkDeprecated(MemberModel member, MethodSpec method) {
        if (!member.isDeprecated() || method.annotations.contains(DEPRECATED)) {
            return method;
        }
        MethodSpec.Builder builder = method.toBuilder().addAnnotation(DEPRECATED);
        if (!method.javadoc.isEmpty()) {
            builder.addJavadoc(Constant.LF + "@deprecated", new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)member.getDeprecatedMessage())) {
                builder.addJavadoc(" $L", new Object[]{member.getDeprecatedMessage()});
            }
        }
        return builder.build();
    }

    public static MethodSpec checkDeprecated(OperationModel operation, MethodSpec method) {
        if (!operation.isDeprecated() || method.annotations.contains(DEPRECATED)) {
            return method;
        }
        MethodSpec.Builder builder = method.toBuilder().addAnnotation(DEPRECATED);
        if (!method.javadoc.isEmpty()) {
            builder.addJavadoc(Constant.LF + "@deprecated", new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)operation.getDeprecatedMessage())) {
                builder.addJavadoc(" $L", new Object[]{operation.getDeprecatedMessage()});
            }
        }
        return builder.build();
    }

    public static List<MethodSpec> checkDeprecated(MemberModel member, List<MethodSpec> methods) {
        return methods.stream().map(methodSpec -> DeprecationUtils.checkDeprecated(member, methodSpec)).collect(Collectors.toList());
    }
}

