/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.net.URI;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.codegen.utils.AuthUtils;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;

public class SyncClientBuilderClass
implements ClassSpec {
    private final IntermediateModel model;
    private final ClassName clientInterfaceName;
    private final ClassName clientClassName;
    private final ClassName builderInterfaceName;
    private final ClassName builderClassName;
    private final ClassName builderBaseClassName;
    private final ClassName serviceConfigClassName;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public SyncClientBuilderClass(IntermediateModel model) {
        String basePackage = model.getMetadata().getFullClientPackageName();
        this.model = model;
        this.clientInterfaceName = ClassName.get((String)basePackage, (String)model.getMetadata().getSyncInterface(), (String[])new String[0]);
        this.clientClassName = ClassName.get((String)basePackage, (String)model.getMetadata().getSyncClient(), (String[])new String[0]);
        this.builderInterfaceName = ClassName.get((String)basePackage, (String)model.getMetadata().getSyncBuilderInterface(), (String[])new String[0]);
        this.builderClassName = ClassName.get((String)basePackage, (String)model.getMetadata().getSyncBuilder(), (String[])new String[0]);
        this.builderBaseClassName = ClassName.get((String)basePackage, (String)model.getMetadata().getBaseBuilder(), (String[])new String[0]);
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(model);
        this.serviceConfigClassName = new PoetExtension(model).getServiceConfigClass();
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.builderClassName).addAnnotation(SdkInternalApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)this.builderBaseClassName, (TypeName[])new TypeName[]{this.builderInterfaceName, this.clientInterfaceName})).addSuperinterface((TypeName)this.builderInterfaceName).addJavadoc("Internal implementation of {@link $T}.", new Object[]{this.builderInterfaceName});
        if (this.model.getEndpointOperation().isPresent()) {
            builder.addMethod(this.endpointDiscoveryEnabled());
            if (this.model.getCustomizationConfig().isEnableEndpointDiscoveryMethodRequired()) {
                builder.addMethod(this.enableEndpointDiscovery());
            }
        }
        builder.addMethod(this.endpointProviderMethod());
        if (AuthUtils.usesBearerAuth(this.model)) {
            builder.addMethod(this.tokenProviderMethodImpl());
        }
        return builder.addMethod(this.buildClientMethod()).build();
    }

    private MethodSpec endpointDiscoveryEnabled() {
        return MethodSpec.methodBuilder((String)"endpointDiscoveryEnabled").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.builderClassName).addParameter(Boolean.TYPE, "endpointDiscoveryEnabled", new Modifier[0]).addStatement("this.endpointDiscoveryEnabled = endpointDiscoveryEnabled", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec enableEndpointDiscovery() {
        return MethodSpec.methodBuilder((String)"enableEndpointDiscovery").addAnnotation(Override.class).addAnnotation(Deprecated.class).addJavadoc("@deprecated Use {@link #endpointDiscoveryEnabled($T)} instead.", new Object[]{Boolean.TYPE}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.builderClassName).addStatement("endpointDiscoveryEnabled = true", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec endpointProviderMethod() {
        return MethodSpec.methodBuilder((String)"endpointProvider").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.className()).addParameter((TypeName)this.endpointRulesSpecUtils.providerInterfaceName(), "endpointProvider", new Modifier[0]).addStatement("clientConfiguration.option($T.ENDPOINT_PROVIDER, endpointProvider)", new Object[]{SdkClientOption.class}).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec buildClientMethod() {
        return MethodSpec.methodBuilder((String)"buildClient").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns((TypeName)this.clientInterfaceName).addStatement("$T clientConfiguration = super.syncClientConfiguration()", new Object[]{SdkClientConfiguration.class}).addStatement("this.validateClientOptions(clientConfiguration)", new Object[0]).addStatement("$T endpointOverride = null", new Object[]{URI.class}).addCode("if (clientConfiguration.option($T.ENDPOINT_OVERRIDDEN) != null&& $T.TRUE.equals(clientConfiguration.option($T.ENDPOINT_OVERRIDDEN))) {endpointOverride = clientConfiguration.option($T.ENDPOINT);}", new Object[]{SdkClientOption.class, Boolean.class, SdkClientOption.class, SdkClientOption.class}).addStatement("$T serviceClientConfiguration = $T.builder().overrideConfiguration(overrideConfiguration()).region(clientConfiguration.option($T.AWS_REGION)).endpointOverride(endpointOverride).build()", new Object[]{this.serviceConfigClassName, this.serviceConfigClassName, AwsClientOption.class}).addStatement("return new $T(serviceClientConfiguration, clientConfiguration)", new Object[]{this.clientClassName}).build();
    }

    private MethodSpec tokenProviderMethodImpl() {
        return MethodSpec.methodBuilder((String)"tokenProvider").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(SdkTokenProvider.class, "tokenProvider", new Modifier[0]).returns((TypeName)this.builderClassName).addStatement("clientConfiguration.option($T.TOKEN_PROVIDER, tokenProvider)", new Object[]{AwsClientOption.class}).addStatement("return this", new Object[0]).build();
    }

    @Override
    public ClassName className() {
        return this.builderClassName;
    }
}

