/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Map;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.BuiltInParameter;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.regions.Region;

public class EndpointParametersClassSpec
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public EndpointParametersClassSpec(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder b = PoetUtils.createClassBuilder(this.className()).addJavadoc("The parameters object used to resolve an endpoint for the $L service.", new Object[]{this.intermediateModel.getMetadata().getServiceName()}).addMethod(this.ctor()).addMethod(this.builderMethod()).addType(this.builderInterfaceSpec()).addType(this.builderImplSpec()).addAnnotation(SdkPublicApi.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.parameters().forEach((name, model) -> {
            b.addField(this.fieldSpec((String)name, (ParameterModel)model).toBuilder().addModifiers(new Modifier[]{Modifier.FINAL}).build());
            b.addMethod(this.accessorMethod((String)name, (ParameterModel)model));
        });
        return b.build();
    }

    @Override
    public ClassName className() {
        return this.endpointRulesSpecUtils.parametersClassName();
    }

    private TypeSpec builderInterfaceSpec() {
        TypeSpec.Builder b = TypeSpec.interfaceBuilder((ClassName)this.builderInterfaceName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.parameters().forEach((name, model) -> b.addMethod(this.setterMethodDeclaration((String)name, (ParameterModel)model)));
        b.addMethod(MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)this.className()).build());
        return b.build();
    }

    private TypeSpec builderImplSpec() {
        TypeSpec.Builder b = TypeSpec.classBuilder((ClassName)this.builderClassName()).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addSuperinterface((TypeName)this.builderInterfaceName());
        this.parameters().forEach((name, model) -> {
            b.addField(this.fieldSpec((String)name, (ParameterModel)model).toBuilder().initializer(this.defaultValueCode((ParameterModel)model)).build());
            b.addMethod(this.builderSetterMethod((String)name, (ParameterModel)model));
        });
        b.addMethod(MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.className()).addCode(CodeBlock.builder().addStatement("return new $T(this)", new Object[]{this.className()}).build()).build());
        return b.build();
    }

    private ClassName builderInterfaceName() {
        return this.className().nestedClass("Builder");
    }

    private ClassName builderClassName() {
        return this.className().nestedClass("BuilderImpl");
    }

    private Map<String, ParameterModel> parameters() {
        return this.intermediateModel.getEndpointRuleSetModel().getParameters();
    }

    private ParameterSpec parameterSpec(String name, ParameterModel model) {
        return ParameterSpec.builder((TypeName)this.endpointRulesSpecUtils.parameterType(model), (String)this.variableName(name), (Modifier[])new Modifier[0]).build();
    }

    private FieldSpec fieldSpec(String name, ParameterModel model) {
        return FieldSpec.builder((TypeName)this.endpointRulesSpecUtils.parameterType(model), (String)this.variableName(name), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private MethodSpec setterMethodDeclaration(String name, ParameterModel model) {
        MethodSpec.Builder b = this.paramMethodBuilder(name, model);
        b.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        b.addParameter(this.parameterSpec(name, model));
        b.returns((TypeName)this.builderInterfaceName());
        return b.build();
    }

    private MethodSpec accessorMethod(String name, ParameterModel model) {
        MethodSpec.Builder b = this.paramMethodBuilder(name, model);
        b.returns(this.endpointRulesSpecUtils.parameterType(model));
        b.addStatement("return $N", new Object[]{this.variableName(name)});
        return b.build();
    }

    private MethodSpec builderSetterMethod(String name, ParameterModel model) {
        String memberName = this.variableName(name);
        MethodSpec.Builder b = this.paramMethodBuilder(name, model).addAnnotation(Override.class).addParameter(this.parameterSpec(name, model)).returns((TypeName)this.builderInterfaceName()).addStatement("this.$1N = $1N", new Object[]{memberName});
        TreeNode defaultValue = model.getDefault();
        if (defaultValue != null) {
            b.beginControlFlow("if (this.$N == null)", new Object[]{memberName});
            b.addStatement("this.$N = $L", new Object[]{memberName, this.defaultValueCode(model)});
            b.endControlFlow();
        }
        b.addStatement("return this", new Object[0]);
        return b.build();
    }

    private MethodSpec ctor() {
        MethodSpec.Builder b = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.builderClassName(), "builder", new Modifier[0]);
        this.parameters().forEach((name, model) -> b.addStatement("this.$1N = builder.$1N", new Object[]{this.variableName((String)name)}));
        return b.build();
    }

    private MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.builderInterfaceName()).addStatement("return new $T()", new Object[]{this.builderClassName()}).build();
    }

    private String variableName(String name) {
        return this.intermediateModel.getNamingStrategy().getVariableName(name);
    }

    private CodeBlock defaultValueCode(ParameterModel parameterModel) {
        CodeBlock.Builder b = CodeBlock.builder();
        TreeNode defaultValue = parameterModel.getDefault();
        if (defaultValue == null) {
            return b.build();
        }
        switch (defaultValue.asToken()) {
            case VALUE_STRING: {
                String stringValue = ((JrsString)defaultValue).getValue();
                if (parameterModel.getBuiltInEnum() == BuiltInParameter.AWS_REGION) {
                    b.add("$T.of($S)", new Object[]{Region.class, stringValue});
                    break;
                }
                b.add("$S", new Object[]{stringValue});
                break;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                b.add("$L", new Object[]{((JrsBoolean)defaultValue).booleanValue()});
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to set default value for parameter of type " + defaultValue.asToken());
            }
        }
        return b.build();
    }

    private MethodSpec.Builder paramMethodBuilder(String name, ParameterModel model) {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)this.endpointRulesSpecUtils.paramMethodName(name));
        b.addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (model.getDeprecated() != null) {
            b.addAnnotation(Deprecated.class);
        }
        return b;
    }
}

