/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import java.util.Map;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.config.customization.CustomSdkShapes;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;

public class CustomSdkShapesProcessor
implements CodegenCustomizationProcessor {
    private final CustomSdkShapes customSdkShapes;

    CustomSdkShapesProcessor(CustomSdkShapes customSdkShapes) {
        this.customSdkShapes = customSdkShapes;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
        if (this.customSdkShapes == null) {
            return;
        }
        Map<String, Shape> shapes = serviceModel.getShapes();
        this.customSdkShapes.getShapes().forEach((shapeName, shape) -> {
            shape.setSynthetic(true);
            shapes.put((String)shapeName, (Shape)shape);
        });
        serviceModel.setShapes(shapes);
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
    }
}

