/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.internal.Jackson;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.RuleModel;
import software.amazon.awssdk.utils.IoUtils;

public class EndpointRuleSetModel {
    private String serviceId;
    private String version;
    private Map<String, ParameterModel> parameters;
    private List<RuleModel> rules;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EndpointRuleSetModel defaultRules(String endpointPrefix) {
        try (InputStream defaultRulesSet = EndpointRuleSetModel.class.getResourceAsStream("/software/amazon/awssdk/codegen/default-endpoint-rule-set.json");){
            String rules = IoUtils.toUtf8String((InputStream)defaultRulesSet);
            rules = String.format(rules, endpointPrefix);
            EndpointRuleSetModel endpointRuleSetModel = Jackson.load(EndpointRuleSetModel.class, rules);
            return endpointRuleSetModel;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, ParameterModel> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, ParameterModel> parameters) {
        this.parameters = parameters;
    }

    public List<RuleModel> getRules() {
        return this.rules;
    }

    public void setRules(List<RuleModel> rules) {
        this.rules = rules;
    }
}

