/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.docs.SimpleMethodOverload;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.SyncClientInterface;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.utils.Validate;

public class DelegatingSyncClientClass
extends SyncClientInterface {
    private final IntermediateModel model;
    private final ClassName className;
    private final PoetExtension poetExtensions;

    public DelegatingSyncClientClass(IntermediateModel model) {
        super(model);
        this.model = model;
        this.className = ClassName.get((String)model.getMetadata().getFullClientPackageName(), (String)("Delegating" + model.getMetadata().getSyncInterface()), (String[])new String[0]);
        this.poetExtensions = new PoetExtension(model);
    }

    @Override
    protected void addInterfaceClass(TypeSpec.Builder type) {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncInterface());
        type.addSuperinterface((TypeName)interfaceClass).addMethod(this.constructor(interfaceClass));
    }

    @Override
    protected TypeSpec.Builder createTypeSpec() {
        return PoetUtils.createClassBuilder(this.className);
    }

    @Override
    protected void addAnnotations(TypeSpec.Builder type) {
        type.addAnnotation(SdkPublicApi.class);
    }

    @Override
    protected void addModifiers(TypeSpec.Builder type) {
        type.addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC});
    }

    @Override
    protected void addFields(TypeSpec.Builder type) {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncInterface());
        type.addField(FieldSpec.builder((TypeName)interfaceClass, (String)"delegate", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
    }

    @Override
    protected void addConsumerMethod(List<MethodSpec> specs, MethodSpec spec, SimpleMethodOverload overload, OperationModel opModel) {
    }

    @Override
    protected void addAdditionalMethods(TypeSpec.Builder type) {
        MethodSpec delegate = MethodSpec.methodBuilder((String)"delegate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return this.delegate", new Object[0]).returns(SdkClient.class).build();
        type.addMethod(this.nameMethod()).addMethod(delegate);
    }

    @Override
    protected void addCloseMethod(TypeSpec.Builder type) {
        MethodSpec method = MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("delegate.close()", new Object[0]).build();
        type.addMethod(method);
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    @Override
    protected MethodSpec.Builder simpleMethodModifier(MethodSpec.Builder builder) {
        return builder.addAnnotation(Override.class);
    }

    @Override
    protected MethodSpec.Builder operationBody(MethodSpec.Builder builder, OperationModel opModel) {
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class);
        builder.addStatement("return delegate.$N($L)", new Object[]{opModel.getMethodName(), builder.parameters.stream().map(p -> p.name).collect(Collectors.joining(", "))});
        return builder;
    }

    @Override
    protected MethodSpec.Builder paginatedMethodBody(MethodSpec.Builder builder, OperationModel opModel) {
        String methodName = PaginatorUtils.getPaginatedMethodName(opModel.getMethodName());
        return builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return delegate.$N($N)", new Object[]{methodName, opModel.getInput().getVariableName()});
    }

    @Override
    protected MethodSpec.Builder utilitiesOperationBody(MethodSpec.Builder builder) {
        return builder.addAnnotation(Override.class).addStatement("return delegate.$N()", new Object[]{"utilities"});
    }

    @Override
    protected MethodSpec.Builder waiterOperationBody(MethodSpec.Builder builder) {
        return builder.addAnnotation(Override.class).addStatement("return delegate.waiter()", new Object[0]);
    }

    private MethodSpec constructor(ClassName interfaceClass) {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)interfaceClass, "delegate", new Modifier[0]).addStatement("$T.paramNotNull(delegate, \"delegate\")", new Object[]{Validate.class}).addStatement("this.delegate = delegate", new Object[0]).build();
    }

    private MethodSpec nameMethod() {
        return MethodSpec.methodBuilder((String)"serviceName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(String.class).addStatement("return delegate.serviceName()", new Object[0]).build();
    }
}

