/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.traits;

import com.squareup.javapoet.CodeBlock;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.interceptor.trait.HttpChecksum;

public class HttpChecksumTrait {
    private HttpChecksumTrait() {
    }

    public static CodeBlock create(OperationModel operationModel) {
        if (operationModel.getHttpChecksum() != null) {
            CodeBlock.Builder codeBuilder = CodeBlock.builder();
            codeBuilder.add(CodeBlock.of((String)".putExecutionAttribute($T.HTTP_CHECKSUM, $T.builder().requestChecksumRequired($L)", (Object[])new Object[]{SdkInternalExecutionAttribute.class, HttpChecksum.class, operationModel.getHttpChecksum().isRequestChecksumRequired()}));
            HttpChecksumTrait.addFluentGetterToBuilder(operationModel, codeBuilder, operationModel.getHttpChecksum().getRequestAlgorithmMember(), "requestAlgorithm");
            HttpChecksumTrait.addFluentGetterToBuilder(operationModel, codeBuilder, operationModel.getHttpChecksum().getRequestValidationModeMember(), "requestValidationMode");
            List<String> responseAlgorithms = operationModel.getHttpChecksum().getResponseAlgorithms();
            if (responseAlgorithms != null && !responseAlgorithms.isEmpty()) {
                codeBuilder.add(CodeBlock.of((String)".responseAlgorithms(", (Object[])new Object[0])).add(CodeBlock.of((String)"$L", (Object[])new Object[]{responseAlgorithms.stream().collect(Collectors.joining("\", \"", "\"", "\""))})).add(CodeBlock.of((String)")", (Object[])new Object[0]));
            }
            codeBuilder.add(CodeBlock.of((String)".isRequestStreaming($L)", (Object[])new Object[]{operationModel.getInputShape().isHasStreamingMember()}));
            return codeBuilder.add(CodeBlock.of((String)".build())", (Object[])new Object[0])).build();
        }
        return CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private static void addFluentGetterToBuilder(OperationModel operationModel, CodeBlock.Builder codeBuilder, String requestValidationModeMemberInModel, String memberBuilderName) {
        if (requestValidationModeMemberInModel != null) {
            MemberModel requestValidationModeMember = operationModel.getInputShape().tryFindMemberModelByC2jName(requestValidationModeMemberInModel, true);
            if (requestValidationModeMember == null) {
                throw new IllegalStateException(requestValidationModeMemberInModel + " is not a member in " + operationModel.getInputShape().getShapeName());
            }
            codeBuilder.add(".$L($N.$N())", new Object[]{memberBuilderName, operationModel.getInput().getVariableName(), requestValidationModeMember.getFluentGetterMethodName()});
        }
    }
}

