/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.fasterxml.jackson.core.TreeNode;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.BuiltInParameter;
import software.amazon.awssdk.codegen.model.rules.endpoints.EndpointTestModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.codegen.poet.rules.TestGeneratorUtils;
import software.amazon.awssdk.core.rules.testing.BaseEndpointProviderTest;
import software.amazon.awssdk.core.rules.testing.EndpointProviderTestCase;
import software.amazon.awssdk.regions.Region;

public class EndpointProviderTestSpec
implements ClassSpec {
    private static final String PROVIDER_NAME = "PROVIDER";
    private final IntermediateModel model;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public EndpointProviderTestSpec(IntermediateModel model) {
        this.model = model;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(model);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder b = PoetUtils.createClassBuilder(this.className()).superclass(BaseEndpointProviderTest.class).addField(this.ruleEngine()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        b.addMethod(this.testMethod());
        b.addMethod(this.testsCasesMethod());
        return b.build();
    }

    @Override
    public ClassName className() {
        return this.endpointRulesSpecUtils.endpointProviderTestsName();
    }

    private FieldSpec ruleEngine() {
        return FieldSpec.builder((TypeName)this.endpointRulesSpecUtils.providerInterfaceName(), (String)PROVIDER_NAME, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.defaultProvider()", new Object[]{this.endpointRulesSpecUtils.providerInterfaceName()}).build();
    }

    private MethodSpec testsCasesMethod() {
        ParameterizedTypeName returnType = ParameterizedTypeName.get(List.class, (Type[])new Type[]{EndpointProviderTestCase.class});
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"testCases").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((TypeName)returnType);
        b.addStatement("$T testCases = new $T<>()", new Object[]{returnType, ArrayList.class});
        this.model.getEndpointTestSuiteModel().getTestCases().forEach(test -> b.addStatement("testCases.add(new $T($L, $L))", new Object[]{EndpointProviderTestCase.class, this.createTestCase((EndpointTestModel)test), TestGeneratorUtils.createExpect(test.getExpect(), null, null)}));
        b.addStatement("return testCases", new Object[0]);
        return b.build();
    }

    private MethodSpec testMethod() {
        AnnotationSpec methodSourceSpec = AnnotationSpec.builder(MethodSource.class).addMember("value", "$S", new Object[]{"testCases"}).build();
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"resolvesCorrectEndpoint").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(EndpointProviderTestCase.class, "tc", new Modifier[0]).addAnnotation(methodSourceSpec).addAnnotation(ParameterizedTest.class).returns(Void.TYPE);
        b.addStatement("verify(tc)", new Object[0]);
        return b.build();
    }

    private CodeBlock createTestCase(EndpointTestModel test) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.beginControlFlow("() ->", new Object[0]);
        ClassName parametersClass = this.endpointRulesSpecUtils.parametersClassName();
        b.add("$T builder = $T.builder();", new Object[]{parametersClass.nestedClass("Builder"), parametersClass});
        if (test.getParams() != null) {
            test.getParams().forEach((n, v) -> {
                if (!this.isDeclaredParam((String)n)) {
                    return;
                }
                String setterName = this.endpointRulesSpecUtils.paramMethodName((String)n);
                CodeBlock valueLiteral = this.endpointRulesSpecUtils.treeNodeToLiteral((TreeNode)v);
                if (this.isRegionBuiltIn((String)n)) {
                    b.add("builder.$N($T.of($L));", new Object[]{setterName, Region.class, valueLiteral});
                } else {
                    b.add("builder.$N($L);", new Object[]{setterName, valueLiteral});
                }
            });
        }
        b.add("return $N.resolveEndpoint(builder.build()).join();", new Object[]{PROVIDER_NAME});
        b.endControlFlow();
        return b.build();
    }

    private boolean isRegionBuiltIn(String paramName) {
        Map<String, ParameterModel> parameters = this.model.getEndpointRuleSetModel().getParameters();
        ParameterModel param = parameters.get(paramName);
        return param.getBuiltInEnum() == BuiltInParameter.AWS_REGION;
    }

    private boolean isDeclaredParam(String paramName) {
        Map<String, ParameterModel> parameters = this.model.getEndpointRuleSetModel().getParameters();
        return parameters.containsKey(paramName);
    }
}

