/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.PoetGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.emitters.tasks.RulesEngineRuntimeGeneratorTask;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.service.ClientContextParam;
import software.amazon.awssdk.codegen.poet.rules.ClientContextParamsClassSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointAuthSchemeInterceptorClassSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointParametersClassSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointProviderInterfaceSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointProviderSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointProviderTestSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointResolverInterceptorSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesClientTestSpec;
import software.amazon.awssdk.codegen.poet.rules.RequestEndpointInterceptorSpec;

public final class EndpointProviderTasks
extends BaseGeneratorTasks {
    private final GeneratorTaskParams generatorTaskParams;

    public EndpointProviderTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.generatorTaskParams = dependencies;
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        ArrayList<GeneratorTask> tasks = new ArrayList<GeneratorTask>();
        tasks.add(this.generateInterface());
        tasks.add(this.generateParams());
        tasks.add(this.generateDefaultProvider());
        tasks.addAll(this.generateInterceptors());
        if (this.shouldGenerateEndpointTests()) {
            tasks.add(this.generateClientTests());
            tasks.add(this.generateProviderTests());
        }
        if (this.hasClientContextParams()) {
            tasks.add(this.generateClientContextParams());
        }
        tasks.add(new RulesEngineRuntimeGeneratorTask(this.generatorTaskParams));
        return tasks;
    }

    private GeneratorTask generateInterface() {
        return new PoetGeneratorTask(this.endpointRulesDir(), this.model.getFileHeader(), new EndpointProviderInterfaceSpec(this.model));
    }

    private GeneratorTask generateParams() {
        return new PoetGeneratorTask(this.endpointRulesDir(), this.model.getFileHeader(), new EndpointParametersClassSpec(this.model));
    }

    private GeneratorTask generateDefaultProvider() {
        return new PoetGeneratorTask(this.endpointRulesInternalDir(), this.model.getFileHeader(), new EndpointProviderSpec(this.model));
    }

    private Collection<GeneratorTask> generateInterceptors() {
        return Arrays.asList(new PoetGeneratorTask(this.endpointRulesInternalDir(), this.model.getFileHeader(), new EndpointResolverInterceptorSpec(this.model)), new PoetGeneratorTask(this.endpointRulesInternalDir(), this.model.getFileHeader(), new RequestEndpointInterceptorSpec(this.model)), new PoetGeneratorTask(this.endpointRulesInternalDir(), this.model.getFileHeader(), new EndpointAuthSchemeInterceptorClassSpec(this.model)));
    }

    private GeneratorTask generateClientTests() {
        return new PoetGeneratorTask(this.endpointTestsDir(), this.model.getFileHeader(), new EndpointRulesClientTestSpec(this.model));
    }

    private GeneratorTask generateProviderTests() {
        return new PoetGeneratorTask(this.endpointTestsDir(), this.model.getFileHeader(), new EndpointProviderTestSpec(this.model));
    }

    private GeneratorTask generateClientContextParams() {
        return new PoetGeneratorTask(this.endpointRulesInternalDir(), this.model.getFileHeader(), new ClientContextParamsClassSpec(this.model));
    }

    private String endpointRulesDir() {
        return this.generatorTaskParams.getPathProvider().getEndpointRulesDirectory();
    }

    private String endpointRulesInternalDir() {
        return this.generatorTaskParams.getPathProvider().getEndpointRulesInternalDirectory();
    }

    private String endpointTestsDir() {
        return this.generatorTaskParams.getPathProvider().getEndpointRulesTestDirectory();
    }

    private boolean shouldGenerateEndpointTests() {
        CustomizationConfig customizationConfig = this.generatorTaskParams.getModel().getCustomizationConfig();
        return !Boolean.TRUE.equals(customizationConfig.isSkipEndpointTestGeneration()) && !this.generatorTaskParams.getModel().getEndpointTestSuiteModel().getTestCases().isEmpty();
    }

    private boolean hasClientContextParams() {
        Map<String, ClientContextParam> clientContextParams = this.model.getClientContextParams();
        return clientContextParams != null && !clientContextParams.isEmpty();
    }
}

