/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.StaticImport;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

class MemberCopierSpec
implements ClassSpec {
    private final MemberModel memberModel;
    private final ServiceModelCopiers serviceModelCopiers;
    private final TypeProvider typeProvider;
    private final PoetExtension poetExtensions;

    MemberCopierSpec(MemberModel memberModel, ServiceModelCopiers serviceModelCopiers, TypeProvider typeProvider, PoetExtension poetExtensions) {
        this.memberModel = memberModel;
        this.serviceModelCopiers = serviceModelCopiers;
        this.typeProvider = typeProvider;
        this.poetExtensions = poetExtensions;
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(PoetUtils.generatedAnnotation()).addMethod(this.copyMethod());
        if (this.memberModel.containsBuildable()) {
            builder.addMethod(this.copyFromBuilderMethod());
            builder.addMethod(this.copyToBuilderMethod());
        }
        if (MemberCopierSpec.isEnumCopyAvailable(this.memberModel)) {
            builder.addMethod(this.enumToStringCopyMethod());
            builder.addMethod(this.stringToEnumCopyMethod());
        }
        return builder.build();
    }

    @Override
    public ClassName className() {
        return this.serviceModelCopiers.copierClassFor(this.memberModel).get();
    }

    @Override
    public Iterable<StaticImport> staticImports() {
        if (this.memberModel.isList()) {
            return Collections.singletonList(StaticImport.staticMethodImport(Collectors.class, "toList"));
        }
        if (this.memberModel.isMap()) {
            return Collections.singletonList(StaticImport.staticMethodImport(Collectors.class, "toMap"));
        }
        return Collections.emptyList();
    }

    public static boolean isEnumCopyAvailable(MemberModel memberModel) {
        if (!memberModel.isMap() && !memberModel.isList()) {
            return false;
        }
        if (memberModel.isMap()) {
            MapModel mapModel = memberModel.getMapModel();
            MemberModel keyModel = mapModel.getKeyModel();
            MemberModel valueModel = mapModel.getValueModel();
            if (keyModel.getEnumType() != null || valueModel.getEnumType() != null) {
                return true;
            }
            if (valueModel.isList() || valueModel.isMap()) {
                return MemberCopierSpec.isEnumCopyAvailable(valueModel);
            }
        } else {
            MemberModel element = memberModel.getListModel().getListMemberModel();
            if (element.getEnumType() != null) {
                return true;
            }
            if (element.isList() || element.isMap()) {
                return MemberCopierSpec.isEnumCopyAvailable(element);
            }
        }
        return false;
    }

    private MethodSpec copyMethod() {
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.copyMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter(this.typeName(this.memberModel, true, true, BuilderTransform.NONE, EnumTransform.NONE), this.memberParamName(), new Modifier[0]).returns(this.typeName(this.memberModel, false, false, BuilderTransform.NONE, EnumTransform.NONE)).addCode(this.copyMethodBody(BuilderTransform.NONE, EnumTransform.NONE)).build();
    }

    private MethodSpec enumToStringCopyMethod() {
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.enumToStringCopyMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter(this.typeName(this.memberModel, true, true, BuilderTransform.NONE, EnumTransform.ENUM_TO_STRING), this.memberParamName(), new Modifier[0]).returns(this.typeName(this.memberModel, false, false, BuilderTransform.NONE, EnumTransform.ENUM_TO_STRING)).addCode(this.copyMethodBody(BuilderTransform.NONE, EnumTransform.ENUM_TO_STRING)).build();
    }

    private MethodSpec stringToEnumCopyMethod() {
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.stringToEnumCopyMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter(this.typeName(this.memberModel, true, true, BuilderTransform.NONE, EnumTransform.STRING_TO_ENUM), this.memberParamName(), new Modifier[0]).returns(this.typeName(this.memberModel, false, false, BuilderTransform.NONE, EnumTransform.STRING_TO_ENUM)).addCode(this.copyMethodBody(BuilderTransform.NONE, EnumTransform.STRING_TO_ENUM)).build();
    }

    private MethodSpec copyFromBuilderMethod() {
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.copyFromBuilderMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).returns(this.typeName(this.memberModel, false, false, BuilderTransform.BUILDER_TO_BUILDABLE, EnumTransform.NONE)).addParameter(this.typeName(this.memberModel, true, true, BuilderTransform.BUILDER_TO_BUILDABLE, EnumTransform.NONE), this.memberParamName(), new Modifier[0]).addCode(this.copyMethodBody(BuilderTransform.BUILDER_TO_BUILDABLE, EnumTransform.NONE)).build();
    }

    private MethodSpec copyToBuilderMethod() {
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.copyToBuilderMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).returns(this.typeName(this.memberModel, false, false, BuilderTransform.BUILDABLE_TO_BUILDER, EnumTransform.NONE)).addParameter(this.typeName(this.memberModel, true, true, BuilderTransform.BUILDABLE_TO_BUILDER, EnumTransform.NONE), this.memberParamName(), new Modifier[0]).addCode(this.copyMethodBody(BuilderTransform.BUILDABLE_TO_BUILDER, EnumTransform.NONE)).build();
    }

    private CodeBlock copyMethodBody(BuilderTransform builderTransform, EnumTransform enumTransform) {
        CodeBlock.Builder code = CodeBlock.builder();
        if (!this.memberModel.getAutoConstructClassIfExists().isPresent()) {
            code.add("if ($N == null) {", new Object[]{this.memberParamName()}).add("return null;", new Object[0]).add("}", new Object[0]);
        }
        String outputVariable = this.copyMethodBody(code, builderTransform, new UniqueVariableSource(), enumTransform, this.memberParamName(), this.memberModel);
        code.add("return $N;", new Object[]{outputVariable});
        return code.build();
    }

    private String copyMethodBody(CodeBlock.Builder code, BuilderTransform builderTransform, UniqueVariableSource variableSource, EnumTransform enumTransform, String inputVariableName, MemberModel inputMember) {
        if (inputMember.getEnumType() != null) {
            String outputVariableName = variableSource.getNew("result");
            ClassName enumType = this.poetExtensions.getModelClass(inputMember.getEnumType());
            switch (enumTransform) {
                case NONE: {
                    return inputVariableName;
                }
                case ENUM_TO_STRING: {
                    code.add("$T $N = $N.toString();", new Object[]{String.class, outputVariableName, inputVariableName});
                    return outputVariableName;
                }
                case STRING_TO_ENUM: {
                    code.add("$1T $2N = $1T.fromValue($3N);", new Object[]{enumType, outputVariableName, inputVariableName});
                    return outputVariableName;
                }
            }
            throw new IllegalStateException();
        }
        if (inputMember.isSimple()) {
            return inputVariableName;
        }
        if (inputMember.hasBuilder()) {
            switch (builderTransform) {
                case NONE: {
                    return inputVariableName;
                }
                case BUILDER_TO_BUILDABLE: {
                    String buildableOutput = variableSource.getNew("member");
                    TypeName buildableOutputType = this.typeName(inputMember, false, false, builderTransform, enumTransform);
                    code.add("$T $N = $N == null ? null : $N.build();", new Object[]{buildableOutputType, buildableOutput, inputVariableName, inputVariableName});
                    return buildableOutput;
                }
                case BUILDABLE_TO_BUILDER: {
                    String builderOutput = variableSource.getNew("member");
                    TypeName builderOutputType = this.typeName(inputMember, false, false, builderTransform, enumTransform);
                    code.add("$T $N = $N == null ? null : $N.toBuilder();", new Object[]{builderOutputType, builderOutput, inputVariableName, inputVariableName});
                    return builderOutput;
                }
            }
            throw new IllegalStateException();
        }
        if (inputMember.isList()) {
            String outputVariableName = variableSource.getNew("list");
            String modifiableVariableName = variableSource.getNew("modifiableList");
            MemberModel listEntryModel = inputMember.getListModel().getListMemberModel();
            TypeName listType = this.typeName(inputMember, false, false, builderTransform, enumTransform);
            code.add("$T $N;", new Object[]{listType, outputVariableName}).add("if ($1N == null || $1N instanceof $2T) {", new Object[]{inputVariableName, SdkAutoConstructList.class}).add("$N = $T.getInstance();", new Object[]{outputVariableName, DefaultSdkAutoConstructList.class}).add("} else {", new Object[0]).add("$T $N = new $T<>();", new Object[]{listType, modifiableVariableName, ArrayList.class});
            String entryInputVariable = variableSource.getNew("entry");
            code.add("$N.forEach($N -> {", new Object[]{inputVariableName, entryInputVariable});
            String entryOutputVariable = this.copyMethodBody(code, builderTransform, variableSource, enumTransform, entryInputVariable, listEntryModel);
            code.add("$N.add($N);", new Object[]{modifiableVariableName, entryOutputVariable}).add("});", new Object[0]).add("$N = $T.unmodifiableList($N);", new Object[]{outputVariableName, Collections.class, modifiableVariableName}).add("}", new Object[0]);
            return outputVariableName;
        }
        if (inputMember.isMap()) {
            String outputVariableName = variableSource.getNew("map");
            String modifiableVariableName = variableSource.getNew("modifiableMap");
            MemberModel keyModel = inputMember.getMapModel().getKeyModel();
            MemberModel valueModel = inputMember.getMapModel().getValueModel();
            TypeName keyType = this.typeName(keyModel, false, false, builderTransform, enumTransform);
            TypeName outputMapType = this.typeName(inputMember, false, false, builderTransform, enumTransform);
            code.add("$T $N;", new Object[]{outputMapType, outputVariableName}).add("if ($1N == null || $1N instanceof $2T) {", new Object[]{inputVariableName, SdkAutoConstructMap.class}).add("$N = $T.getInstance();", new Object[]{outputVariableName, DefaultSdkAutoConstructMap.class}).add("} else {", new Object[0]).add("$T $N = new $T<>();", new Object[]{outputMapType, modifiableVariableName, LinkedHashMap.class});
            String keyInputVariable = variableSource.getNew("key");
            String valueInputVariable = variableSource.getNew("value");
            code.add("$N.forEach(($N, $N) -> {", new Object[]{inputVariableName, keyInputVariable, valueInputVariable});
            String keyOutputVariable = this.copyMethodBody(code, builderTransform, variableSource, enumTransform, keyInputVariable, keyModel);
            String valueOutputVariable = this.copyMethodBody(code, builderTransform, variableSource, enumTransform, valueInputVariable, valueModel);
            if (keyModel.getEnumType() != null && !keyType.toString().equals("java.lang.String")) {
                code.add("if ($N != $T.UNKNOWN_TO_SDK_VERSION) {", new Object[]{keyOutputVariable, keyType}).add("$N.put($N, $N);", new Object[]{modifiableVariableName, keyOutputVariable, valueOutputVariable}).add("}", new Object[0]);
            } else {
                code.add("$N.put($N, $N);", new Object[]{modifiableVariableName, keyOutputVariable, valueOutputVariable});
            }
            code.add("});", new Object[0]).add("$N = $T.unmodifiableMap($N);", new Object[]{outputVariableName, Collections.class, modifiableVariableName}).add("}", new Object[0]);
            return outputVariableName;
        }
        throw new UnsupportedOperationException("Unable to generate copier for member '" + inputMember + "'");
    }

    private TypeName typeName(MemberModel model, boolean isInputType, boolean useCollectionForList, BuilderTransform builderTransform, EnumTransform enumTransform) {
        boolean useEnumTypes = isInputType && enumTransform == EnumTransform.ENUM_TO_STRING || !isInputType && enumTransform == EnumTransform.STRING_TO_ENUM;
        boolean useBuilderTypes = isInputType && builderTransform == BuilderTransform.BUILDER_TO_BUILDABLE || !isInputType && builderTransform == BuilderTransform.BUILDABLE_TO_BUILDER;
        return this.typeProvider.typeName(model, new TypeProvider.TypeNameOptions().useEnumTypes(useEnumTypes).shapeTransformation(useBuilderTypes ? TypeProvider.ShapeTransformation.USE_BUILDER : TypeProvider.ShapeTransformation.NONE).useSubtypeWildcardsForCollections(isInputType).useSubtypeWildcardsForBuilders(isInputType).useCollectionForList(useCollectionForList));
    }

    private String memberParamName() {
        if (this.memberModel.isSimple()) {
            return Utils.unCapitalize(this.memberModel.getVariable().getSimpleType()) + "Param";
        }
        return Utils.unCapitalize(this.memberModel.getC2jShape()) + "Param";
    }

    private static final class UniqueVariableSource {
        private final Map<String, Integer> suffixes = new HashMap<String, Integer>();

        private UniqueVariableSource() {
        }

        private String getNew(String prefix) {
            return prefix + this.suffix(prefix);
        }

        private String suffix(String prefix) {
            Integer suffixNumber = this.suffixes.compute(prefix, (k, v) -> v == null ? 0 : v + 1);
            return suffixNumber == 0 ? "" : suffixNumber.toString();
        }
    }

    private static enum BuilderTransform {
        BUILDER_TO_BUILDABLE,
        BUILDABLE_TO_BUILDER,
        NONE;

    }

    private static enum EnumTransform {
        STRING_TO_ENUM,
        ENUM_TO_STRING,
        NONE;

    }
}

