/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.model.EventModelBuilderSpecs;
import software.amazon.awssdk.codegen.poet.model.EventStreamSpecHelper;
import software.amazon.awssdk.codegen.poet.model.ShapeModelSpec;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

public final class EventModelSpec
implements ClassSpec {
    private final MemberModel eventModel;
    private final ShapeModel eventStream;
    private final IntermediateModel intermediateModel;
    private final PoetExtensions poetExtensions;
    private final ShapeModelSpec baseShapeModelSpec;
    private final TypeProvider typeProvider;
    private final EventStreamSpecHelper eventStreamSpecHelper;
    private final EventModelBuilderSpecs builderSpecs;

    public EventModelSpec(MemberModel eventModel, ShapeModel eventStream, IntermediateModel intermediateModel) {
        this.eventModel = eventModel;
        this.eventStream = eventStream;
        this.intermediateModel = intermediateModel;
        this.poetExtensions = new PoetExtensions(intermediateModel);
        this.baseShapeModelSpec = new ShapeModelSpec(eventModel.getShape(), new TypeProvider(intermediateModel), this.poetExtensions, intermediateModel);
        this.typeProvider = new TypeProvider(intermediateModel);
        this.eventStreamSpecHelper = new EventStreamSpecHelper(eventStream, intermediateModel);
        this.builderSpecs = new EventModelBuilderSpecs(intermediateModel, eventModel, this.className(), this.typeProvider);
    }

    @Override
    public TypeSpec poetSpec() {
        return TypeSpec.classBuilder((ClassName)this.className()).superclass((TypeName)this.baseShapeModelSpec.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkInternalApi.class).addAnnotation(PoetUtils.generatedAnnotation()).addJavadoc(this.classJavadoc()).addField(this.serialVersionUidField()).addMethod(this.constructor()).addMethod(this.toBuilderMethod()).addMethod(this.builderMethod()).addMethods(this.acceptMethods()).addMethod(this.sdkEventTypeMethodSpec()).addTypes(Arrays.asList(this.builderSpecs.builderInterface(), this.builderSpecs.beanStyleBuilder())).build();
    }

    private CodeBlock classJavadoc() {
        return CodeBlock.builder().add("A specialization of {@code $L} that represents the {@code $L$$$L} event. Do not use this class directly. Instead, use the static builder methods on {@link $L}.", new Object[]{this.baseShapeModelSpec.className(), this.eventStream.getC2jName(), this.eventModel.getC2jName(), this.poetExtensions.getModelClass(this.eventStream.getShapeName())}).build();
    }

    private FieldSpec serialVersionUidField() {
        return FieldSpec.builder(Long.TYPE, (String)"serialVersionUID", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("1L", new Object[0]).build();
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addParameter((TypeName)this.className().nestedClass("BuilderImpl"), "builderImpl", new Modifier[0]).addStatement("super($N)", new Object[]{"builderImpl"}).build();
    }

    private MethodSpec toBuilderMethod() {
        return MethodSpec.methodBuilder((String)"toBuilder").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.builderSpecs.builderInterfaceName()).addStatement("return new $T(this)", new Object[]{this.builderSpecs.builderImplName()}).build();
    }

    private MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.builderSpecs.builderInterfaceName()).addStatement("return new $T()", new Object[]{this.builderSpecs.builderImplName()}).build();
    }

    private List<MethodSpec> acceptMethods() {
        return this.operationsUsingEventOnOutput().stream().map(o -> {
            ClassName responseHandlerClass = this.poetExtensions.eventStreamResponseHandlerType((OperationModel)o);
            return this.acceptMethodSpec(responseHandlerClass);
        }).collect(Collectors.toList());
    }

    @Override
    public ClassName className() {
        return this.eventStreamSpecHelper.eventClassName(this.eventModel);
    }

    private List<OperationModel> operationsUsingEventOnOutput() {
        Collection<OperationModel> opModels = EventStreamUtils.findOperationsWithEventStream(this.intermediateModel, this.eventStream);
        return opModels.stream().filter(opModel -> EventStreamUtils.doesShapeContainsEventStream(opModel.getOutputShape(), this.eventStream)).collect(Collectors.toList());
    }

    private MethodSpec acceptMethodSpec(ClassName responseHandlerClass) {
        String visitMethodName = this.eventStreamSpecHelper.visitMethodName(this.eventModel);
        return MethodSpec.methodBuilder((String)"accept").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)responseHandlerClass.nestedClass("Visitor"), "visitor", new Modifier[0]).addStatement("visitor.$N(this)", new Object[]{visitMethodName}).build();
    }

    private MethodSpec sdkEventTypeMethodSpec() {
        ClassName eventTypeEnumClass = this.eventStreamSpecHelper.eventTypeEnumClassName();
        String eventTypeValue = this.eventStreamSpecHelper.eventTypeEnumValue(this.eventModel);
        return MethodSpec.methodBuilder((String)"sdkEventType").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)eventTypeEnumClass).addStatement("return $T.$N", new Object[]{eventTypeEnumClass, eventTypeValue}).build();
    }
}

