/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.utils;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.codegen.internal.Jackson;

public final class ModelLoaderUtils {
    private static final Logger log = LoggerFactory.getLogger(ModelLoaderUtils.class);

    private ModelLoaderUtils() {
    }

    public static <T> T loadModel(Class<T> clzz, File file) {
        try {
            return Jackson.load(clzz, file);
        }
        catch (IOException e) {
            log.error("Failed to read the configuration file {}", (Object)file.getAbsolutePath());
            throw new RuntimeException(e);
        }
    }

    public static <T> T loadModel(Class<T> clzz, File file, boolean failOnUnknownProperties) {
        try {
            return Jackson.load(clzz, file, failOnUnknownProperties);
        }
        catch (IOException e) {
            log.error("Failed to read the configuration file {}", (Object)file.getAbsolutePath());
            throw new RuntimeException(e);
        }
    }

    public static <T> Optional<T> loadOptionalModel(Class<T> clzz, File file) {
        if (!file.exists()) {
            return Optional.empty();
        }
        return Optional.of(ModelLoaderUtils.loadModel(clzz, file));
    }

    public static <T> Optional<T> loadOptionalModel(Class<T> clzz, File file, boolean failOnUnknownProperties) {
        if (!file.exists()) {
            return Optional.empty();
        }
        return Optional.of(ModelLoaderUtils.loadModel(clzz, file, failOnUnknownProperties));
    }
}

