/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.jmespath.parser;

import java.util.function.Function;
import software.amazon.awssdk.utils.Validate;

public final class ParseResult<T> {
    private final T result;

    private ParseResult(T result) {
        this.result = result;
    }

    public static <T> ParseResult<T> success(T result) {
        Validate.notNull(result, (String)"result", (Object[])new Object[0]);
        return new ParseResult<T>(result);
    }

    public static <T> ParseResult<T> error() {
        return new ParseResult<Object>(null);
    }

    public <U> ParseResult<U> mapResult(Function<T, U> mapper) {
        if (this.hasResult()) {
            return ParseResult.success(mapper.apply(this.result));
        }
        return ParseResult.error();
    }

    public boolean hasResult() {
        return this.result != null;
    }

    public T result() {
        Validate.validState((boolean)this.hasResult(), (String)"Result not available", (Object[])new Object[0]);
        return this.result;
    }
}

