/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.jmespath.component;

import software.amazon.awssdk.codegen.jmespath.component.BracketSpecifierWithContents;
import software.amazon.awssdk.codegen.jmespath.component.BracketSpecifierWithQuestionMark;
import software.amazon.awssdk.codegen.jmespath.component.BracketSpecifierWithoutContents;
import software.amazon.awssdk.codegen.jmespath.component.SliceExpression;
import software.amazon.awssdk.codegen.jmespath.component.WildcardExpression;
import software.amazon.awssdk.codegen.jmespath.parser.JmesPathVisitor;
import software.amazon.awssdk.utils.Validate;

public class BracketSpecifier {
    private BracketSpecifierWithContents bracketSpecifierWithContents;
    private BracketSpecifierWithoutContents bracketSpecifierWithoutContents;
    private BracketSpecifierWithQuestionMark bracketSpecifierWithQuestionMark;

    public static BracketSpecifier withContents(BracketSpecifierWithContents bracketSpecifierWithContents) {
        Validate.notNull((Object)bracketSpecifierWithContents, (String)"bracketSpecifierWithContents", (Object[])new Object[0]);
        BracketSpecifier result = new BracketSpecifier();
        result.bracketSpecifierWithContents = bracketSpecifierWithContents;
        return result;
    }

    public static BracketSpecifier withNumberContents(int numberContents) {
        return BracketSpecifier.withContents(BracketSpecifierWithContents.number(numberContents));
    }

    public static BracketSpecifier withSliceExpressionContents(SliceExpression sliceExpression) {
        return BracketSpecifier.withContents(BracketSpecifierWithContents.sliceExpression(sliceExpression));
    }

    public static BracketSpecifier withWildcardExpressionContents(WildcardExpression wildcardExpression) {
        return BracketSpecifier.withContents(BracketSpecifierWithContents.wildcardExpression(wildcardExpression));
    }

    public static BracketSpecifier withoutContents() {
        BracketSpecifier result = new BracketSpecifier();
        result.bracketSpecifierWithoutContents = new BracketSpecifierWithoutContents();
        return result;
    }

    public static BracketSpecifier withQuestionMark(BracketSpecifierWithQuestionMark bracketSpecifierWithQuestionMark) {
        Validate.notNull((Object)bracketSpecifierWithQuestionMark, (String)"bracketSpecifierWithQuestionMark", (Object[])new Object[0]);
        BracketSpecifier result = new BracketSpecifier();
        result.bracketSpecifierWithQuestionMark = bracketSpecifierWithQuestionMark;
        return result;
    }

    public boolean isBracketSpecifierWithContents() {
        return this.bracketSpecifierWithContents != null;
    }

    public boolean isBracketSpecifierWithoutContents() {
        return this.bracketSpecifierWithoutContents != null;
    }

    public boolean isBracketSpecifierWithQuestionMark() {
        return this.bracketSpecifierWithQuestionMark != null;
    }

    public BracketSpecifierWithContents asBracketSpecifierWithContents() {
        Validate.validState((boolean)this.isBracketSpecifierWithContents(), (String)"Not a BracketSpecifierWithContents", (Object[])new Object[0]);
        return this.bracketSpecifierWithContents;
    }

    public BracketSpecifierWithoutContents asBracketSpecifierWithoutContents() {
        Validate.validState((boolean)this.isBracketSpecifierWithoutContents(), (String)"Not a BracketSpecifierWithoutContents", (Object[])new Object[0]);
        return this.bracketSpecifierWithoutContents;
    }

    public BracketSpecifierWithQuestionMark asBracketSpecifierWithQuestionMark() {
        Validate.validState((boolean)this.isBracketSpecifierWithQuestionMark(), (String)"Not a BracketSpecifierWithQuestionMark", (Object[])new Object[0]);
        return this.bracketSpecifierWithQuestionMark;
    }

    public void visit(JmesPathVisitor visitor) {
        if (this.isBracketSpecifierWithContents()) {
            visitor.visitBracketSpecifierWithContents(this.asBracketSpecifierWithContents());
        } else if (this.isBracketSpecifierWithoutContents()) {
            visitor.visitBracketSpecifierWithoutContents(this.asBracketSpecifierWithoutContents());
        } else if (this.isBracketSpecifierWithQuestionMark()) {
            visitor.visitBracketSpecifierWithQuestionMark(this.asBracketSpecifierWithQuestionMark());
        } else {
            throw new IllegalStateException();
        }
    }
}

