/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.naming;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public class DefaultNamingStrategy
implements NamingStrategy {
    private static Logger log = Logger.loggerFor(DefaultNamingStrategy.class);
    private static final String COLLISION_DISAMBIGUATION_PREFIX = "Default";
    private static final Set<String> RESERVED_KEYWORDS;
    private static final Set<String> RESERVED_EXCEPTION_METHOD_NAMES;
    private static final Set<Object> RESERVED_STRUCTURE_METHOD_NAMES;
    private final ServiceModel serviceModel;
    private final CustomizationConfig customizationConfig;

    public DefaultNamingStrategy(ServiceModel serviceModel, CustomizationConfig customizationConfig) {
        this.serviceModel = serviceModel;
        this.customizationConfig = customizationConfig;
    }

    private static boolean isJavaKeyword(String word) {
        return RESERVED_KEYWORDS.contains(word) || RESERVED_KEYWORDS.contains(StringUtils.lowerCase((String)word));
    }

    @Override
    public String getServiceName() {
        String baseName = Stream.of(this.serviceModel.getMetadata().getServiceId()).filter(Objects::nonNull).filter(s -> !s.trim().isEmpty()).findFirst().orElseThrow(() -> new IllegalStateException("ServiceId is missing in the c2j model."));
        baseName = CodegenNamingUtils.pascalCase((String)baseName);
        baseName = Utils.removeLeading(baseName, "Amazon");
        baseName = Utils.removeLeading(baseName, "Aws");
        baseName = Utils.removeTrailing(baseName, "Service");
        return baseName;
    }

    @Override
    public String getClientPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s");
    }

    @Override
    public String getModelPackageName(String serviceName) {
        if (this.customizationConfig.getShareModelConfig() != null && this.customizationConfig.getShareModelConfig().getShareModelWith() != null) {
            serviceName = this.customizationConfig.getShareModelConfig().getShareModelWith();
        }
        return this.getCustomizedPackageName(serviceName, "%s.model");
    }

    @Override
    public String getTransformPackageName(String serviceName) {
        if (this.customizationConfig.getShareModelConfig() != null && this.customizationConfig.getShareModelConfig().getShareModelWith() != null) {
            serviceName = this.customizationConfig.getShareModelConfig().getShareModelWith();
        }
        return this.getCustomizedPackageName(serviceName, "%s.transform");
    }

    @Override
    public String getRequestTransformPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.transform");
    }

    @Override
    public String getPaginatorsPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.paginators");
    }

    @Override
    public String getSmokeTestPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.smoketests");
    }

    private String concatServiceNameIfShareModel(String serviceName) {
        if (this.customizationConfig.getShareModelConfig() != null) {
            return this.customizationConfig.getShareModelConfig().getShareModelWith() + "." + Optional.ofNullable(this.customizationConfig.getShareModelConfig().getPackageName()).orElse(serviceName);
        }
        return serviceName;
    }

    private String screamCase(String word) {
        return Stream.of(CodegenNamingUtils.splitOnWordBoundaries((String)word)).map(s -> s.toUpperCase(Locale.US)).collect(Collectors.joining("_"));
    }

    private String getCustomizedPackageName(String serviceName, String defaultPattern) {
        return String.format(defaultPattern, StringUtils.lowerCase((String)serviceName));
    }

    @Override
    public String getExceptionName(String errorShapeName) {
        String baseName = errorShapeName.endsWith("Fault") ? CodegenNamingUtils.pascalCase((String)errorShapeName.substring(0, errorShapeName.length() - "Fault".length())) + "Exception" : (errorShapeName.endsWith("Exception") ? CodegenNamingUtils.pascalCase((String)errorShapeName) : CodegenNamingUtils.pascalCase((String)errorShapeName) + "Exception");
        if (baseName.equals(this.getServiceName() + "Exception")) {
            return COLLISION_DISAMBIGUATION_PREFIX + baseName;
        }
        return baseName;
    }

    @Override
    public String getRequestClassName(String operationName) {
        String baseName = CodegenNamingUtils.pascalCase((String)operationName) + "Request";
        if (!operationName.equals(this.getServiceName())) {
            return baseName;
        }
        return COLLISION_DISAMBIGUATION_PREFIX + baseName;
    }

    @Override
    public String getResponseClassName(String operationName) {
        String baseName = CodegenNamingUtils.pascalCase((String)operationName) + "Response";
        if (!operationName.equals(this.getServiceName())) {
            return baseName;
        }
        return COLLISION_DISAMBIGUATION_PREFIX + baseName;
    }

    @Override
    public String getVariableName(String name) {
        if (DefaultNamingStrategy.isJavaKeyword(name) || RESERVED_STRUCTURE_METHOD_NAMES.contains(name) || RESERVED_EXCEPTION_METHOD_NAMES.contains(name)) {
            return Utils.unCapitalize(name + "Value");
        }
        return Utils.unCapitalize(name);
    }

    @Override
    public String getEnumValueName(String enumValue) {
        String result = enumValue;
        result = result.replaceAll("textORcsv", "TEXT_OR_CSV");
        result = String.join((CharSequence)"_", CodegenNamingUtils.splitOnWordBoundaries((String)result));
        if (!(result = StringUtils.upperCase((String)result)).matches("^[A-Z][A-Z0-9_]*$")) {
            String attempt = result;
            log.warn(() -> "Invalid enum member generated for input '" + enumValue + "'. Best attempt: '" + attempt + "' If this enum is not customized out, the build will fail.");
        }
        return result;
    }

    @Override
    public String getJavaClassName(String shapeName) {
        return Arrays.stream(shapeName.split("[._-]|\\W")).filter(s -> !StringUtils.isEmpty((CharSequence)s)).map(Utils::capitalize).collect(Collectors.joining());
    }

    @Override
    public String getAuthorizerClassName(String shapeName) {
        String converted = this.getJavaClassName(shapeName);
        if (converted.length() > 0 && !Character.isLetter(converted.charAt(0))) {
            return "I" + converted;
        }
        return converted;
    }

    @Override
    public String getFluentGetterMethodName(String memberName, Shape parentShape, Shape shape) {
        String getterMethodName = Utils.unCapitalize(memberName);
        getterMethodName = this.rewriteInvalidMemberName(getterMethodName, parentShape);
        if (Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes())) {
            getterMethodName = getterMethodName + "AsString";
            if (Utils.isListShape(shape) || Utils.isMapShape(shape)) {
                getterMethodName = getterMethodName + "s";
            }
        }
        return getterMethodName;
    }

    @Override
    public String getFluentEnumGetterMethodName(String memberName, Shape parentShape, Shape shape) {
        if (!Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes())) {
            return null;
        }
        String getterMethodName = Utils.unCapitalize(memberName);
        getterMethodName = this.rewriteInvalidMemberName(getterMethodName, parentShape);
        return getterMethodName;
    }

    @Override
    public String getExistenceCheckMethodName(String memberName, Shape parentShape) {
        String existenceCheckMethodName = Utils.unCapitalize(memberName);
        existenceCheckMethodName = this.rewriteInvalidMemberName(existenceCheckMethodName, parentShape);
        return String.format("has%s", Utils.capitalize(existenceCheckMethodName));
    }

    @Override
    public String getBeanStyleGetterMethodName(String memberName, Shape parentShape, Shape c2jShape) {
        String fluentGetterMethodName = Utils.isOrContainsEnumShape(c2jShape, this.serviceModel.getShapes()) ? this.getFluentEnumGetterMethodName(memberName, parentShape, c2jShape) : this.getFluentGetterMethodName(memberName, parentShape, c2jShape);
        return String.format("get%s", Utils.capitalize(fluentGetterMethodName));
    }

    @Override
    public String getBeanStyleSetterMethodName(String memberName, Shape parentShape, Shape c2jShape) {
        String beanStyleGetter = this.getBeanStyleGetterMethodName(memberName, parentShape, c2jShape);
        return String.format("set%s", beanStyleGetter.substring("get".length()));
    }

    @Override
    public String getFluentSetterMethodName(String memberName, Shape parentShape, Shape shape) {
        String setterMethodName = Utils.unCapitalize(memberName);
        setterMethodName = this.rewriteInvalidMemberName(setterMethodName, parentShape);
        if (Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes()) && (Utils.isListShape(shape) || Utils.isMapShape(shape))) {
            setterMethodName = setterMethodName + "WithStrings";
        }
        return setterMethodName;
    }

    @Override
    public String getFluentEnumSetterMethodName(String memberName, Shape parentShape, Shape shape) {
        if (!Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes())) {
            return null;
        }
        String setterMethodName = Utils.unCapitalize(memberName);
        setterMethodName = this.rewriteInvalidMemberName(setterMethodName, parentShape);
        return setterMethodName;
    }

    @Override
    public String getSdkFieldFieldName(MemberModel memberModel) {
        return this.screamCase(memberModel.getName()) + "_FIELD";
    }

    private String rewriteInvalidMemberName(String memberName, Shape parentShape) {
        if (DefaultNamingStrategy.isJavaKeyword(memberName) || this.isDisallowedNameForShape(memberName, parentShape)) {
            return Utils.unCapitalize(memberName + "Value");
        }
        return memberName;
    }

    private boolean isDisallowedNameForShape(String name, Shape parentShape) {
        if (parentShape.isException()) {
            return RESERVED_EXCEPTION_METHOD_NAMES.contains(name);
        }
        return RESERVED_STRUCTURE_METHOD_NAMES.contains(name);
    }

    static {
        HashSet reservedJavaKeywords = new HashSet();
        Collections.addAll(reservedJavaKeywords, "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while");
        RESERVED_KEYWORDS = Collections.unmodifiableSet(reservedJavaKeywords);
        HashSet reservedJavaMethodNames = new HashSet();
        Collections.addAll(reservedJavaMethodNames, "equals", "finalize", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait");
        HashSet reserveJavaPojoMethodNames = new HashSet(reservedJavaMethodNames);
        Collections.addAll(reserveJavaPojoMethodNames, "builder", "sdkFields", "toBuilder");
        HashSet reservedExceptionMethodNames = new HashSet(reserveJavaPojoMethodNames);
        Collections.addAll(reservedExceptionMethodNames, "awsErrorDetails", "cause", "fillInStackTrace", "getCause", "getLocalizedMessage", "getMessage", "getStackTrace", "getSuppressed", "isClockSkewException", "isThrottlingException", "printStackTrace", "requestId", "retryable", "serializableBuilderClass", "statusCode");
        RESERVED_EXCEPTION_METHOD_NAMES = Collections.unmodifiableSet(reservedExceptionMethodNames);
        HashSet reservedStructureMethodNames = new HashSet(reserveJavaPojoMethodNames);
        Collections.addAll(reservedStructureMethodNames, "overrideConfiguration", "sdkHttpResponse");
        RESERVED_STRUCTURE_METHOD_NAMES = Collections.unmodifiableSet(reservedStructureMethodNames);
    }
}

