/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.internal;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.service.Shape;
import software.amazon.awssdk.codegen.model.service.ShapeType;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.core.SdkBytes;

public class TypeUtils {
    private static final Map<String, String> DATA_TYPE_MAPPINGS = new HashMap<String, String>();
    private static final Map<String, String> MARSHALLING_TYPE_MAPPINGS = new HashMap<String, String>();
    private final NamingStrategy namingStrategy;

    public TypeUtils(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public static String getMarshallingType(String simpleType) {
        return MARSHALLING_TYPE_MAPPINGS.get(simpleType);
    }

    public static boolean isSimple(String type) {
        return DATA_TYPE_MAPPINGS.containsKey(type) || DATA_TYPE_MAPPINGS.containsValue(type);
    }

    public static String getDataTypeMapping(String type) {
        return DATA_TYPE_MAPPINGS.get(type);
    }

    public String getJavaDataType(Map<String, Shape> shapes, String shapeName) {
        return this.getJavaDataType(shapes, shapeName, null);
    }

    public String getJavaDataType(Map<String, Shape> shapes, String shapeName, CustomizationConfig customConfig) {
        if (shapeName == null || shapeName.trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot derive shape type. Shape name cannot be null or empty");
        }
        Shape shape = shapes.get(shapeName);
        if (shape == null) {
            throw new IllegalArgumentException("Cannot derive shape type. No shape information available for " + shapeName);
        }
        String shapeType = shape.getType();
        if (ShapeType.Structure.getName().equals(shapeType)) {
            return this.namingStrategy.getJavaClassName(shapeName);
        }
        if (ShapeType.List.getName().equals(shapeType)) {
            String listContainerType = DATA_TYPE_MAPPINGS.get("listInterface");
            return listContainerType + "<" + this.getJavaDataType(shapes, shape.getListMember().getShape()) + ">";
        }
        if (ShapeType.Map.getName().equals(shapeType)) {
            String mapContainerType = DATA_TYPE_MAPPINGS.get("mapInterface");
            return mapContainerType + "<" + this.getJavaDataType(shapes, shape.getMapKeyType().getShape()) + "," + this.getJavaDataType(shapes, shape.getMapValueType().getShape()) + ">";
        }
        if (shape.isStreaming()) {
            return DATA_TYPE_MAPPINGS.get("stream");
        }
        String dataType = DATA_TYPE_MAPPINGS.get(shapeType);
        if (dataType == null) {
            throw new RuntimeException("Equivalent Java data type cannot be found for data type : " + shapeType);
        }
        return dataType;
    }

    static {
        DATA_TYPE_MAPPINGS.put("string", String.class.getSimpleName());
        DATA_TYPE_MAPPINGS.put("boolean", Boolean.class.getSimpleName());
        DATA_TYPE_MAPPINGS.put("int", Integer.class.getSimpleName());
        DATA_TYPE_MAPPINGS.put("any", Object.class.getSimpleName());
        DATA_TYPE_MAPPINGS.put("integer", Integer.class.getSimpleName());
        DATA_TYPE_MAPPINGS.put("double", Double.class.getSimpleName());
        DATA_TYPE_MAPPINGS.put("short", Short.class.getSimpleName());
        DATA_TYPE_MAPPINGS.put("long", Long.class.getSimpleName());
        DATA_TYPE_MAPPINGS.put("float", Float.class.getSimpleName());
        DATA_TYPE_MAPPINGS.put("byte", Byte.class.getSimpleName());
        DATA_TYPE_MAPPINGS.put("timestamp", Instant.class.getName());
        DATA_TYPE_MAPPINGS.put("blob", SdkBytes.class.getName());
        DATA_TYPE_MAPPINGS.put("stream", InputStream.class.getName());
        DATA_TYPE_MAPPINGS.put("bigdecimal", BigDecimal.class.getName());
        DATA_TYPE_MAPPINGS.put("biginteger", BigInteger.class.getName());
        DATA_TYPE_MAPPINGS.put("list", List.class.getSimpleName());
        DATA_TYPE_MAPPINGS.put("map", Map.class.getSimpleName());
        DATA_TYPE_MAPPINGS.put("listInterface", List.class.getName());
        DATA_TYPE_MAPPINGS.put("listDefaultImpl", ArrayList.class.getName());
        DATA_TYPE_MAPPINGS.put("mapInterface", Map.class.getName());
        DATA_TYPE_MAPPINGS.put("mapDefaultImpl", HashMap.class.getName());
        MARSHALLING_TYPE_MAPPINGS.put("String", "STRING");
        MARSHALLING_TYPE_MAPPINGS.put("Integer", "INTEGER");
        MARSHALLING_TYPE_MAPPINGS.put("Long", "LONG");
        MARSHALLING_TYPE_MAPPINGS.put("Float", "FLOAT");
        MARSHALLING_TYPE_MAPPINGS.put("Double", "DOUBLE");
        MARSHALLING_TYPE_MAPPINGS.put("Instant", "INSTANT");
        MARSHALLING_TYPE_MAPPINGS.put("SdkBytes", "SDK_BYTES");
        MARSHALLING_TYPE_MAPPINGS.put("Boolean", "BOOLEAN");
        MARSHALLING_TYPE_MAPPINGS.put("BigDecimal", "BIG_DECIMAL");
        MARSHALLING_TYPE_MAPPINGS.put("InputStream", "STREAM");
        MARSHALLING_TYPE_MAPPINGS.put(null, "NULL");
    }

    public static final class TypeKey {
        public static final String LIST_INTERFACE = "listInterface";
        public static final String LIST_DEFAULT_IMPL = "listDefaultImpl";
        public static final String MAP_INTERFACE = "mapInterface";
        public static final String MAP_DEFAULT_IMPL = "mapDefaultImpl";
    }
}

