/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.StaticImport;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

class MemberCopierSpec
implements ClassSpec {
    private final MemberModel memberModel;
    private final ServiceModelCopiers serviceModelCopiers;
    private final TypeProvider typeProvider;
    private final PoetExtensions poetExtensions;

    MemberCopierSpec(MemberModel memberModel, ServiceModelCopiers serviceModelCopiers, TypeProvider typeProvider, PoetExtensions poetExtensions) {
        this.memberModel = memberModel;
        this.serviceModelCopiers = serviceModelCopiers;
        this.typeProvider = typeProvider;
        this.poetExtensions = poetExtensions;
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(PoetUtils.generatedAnnotation()).addMethod(this.copyMethod());
        if (this.serviceModelCopiers.requiresBuilderCopier(this.memberModel)) {
            builder.addMethod(this.builderCopyMethod());
        }
        if (Utils.isListWithEnumShape(this.memberModel) || Utils.isMapWithEnumShape(this.memberModel)) {
            builder.addMethod(this.enumToStringCopyMethod());
        }
        return builder.build();
    }

    @Override
    public ClassName className() {
        return this.serviceModelCopiers.copierClassFor(this.memberModel).get();
    }

    @Override
    public Iterable<StaticImport> staticImports() {
        if (this.memberModel.isList()) {
            return Collections.singletonList(StaticImport.staticMethodImport(Collectors.class, "toList"));
        }
        if (this.memberModel.isMap()) {
            return Collections.singletonList(StaticImport.staticMethodImport(Collectors.class, "toMap"));
        }
        return Collections.emptyList();
    }

    private MethodSpec copyMethod() {
        return this.copyMethodProto().addCode(this.copyMethodBody()).build();
    }

    private MethodSpec.Builder copyMethodProto() {
        return this.copyMethodProto(this.typeProvider.parameterType(this.memberModel), this.serviceModelCopiers.copyMethodName());
    }

    private MethodSpec.Builder copyMethodProto(TypeName parameterType, String methodName) {
        return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter(parameterType, this.memberParamName(), new Modifier[0]).returns(this.typeProvider.fieldType(this.memberModel));
    }

    private MethodSpec enumToStringCopyMethod() {
        return this.copyMethodProto(this.paramaterTypeForEnumToStringCopyMethod(), this.serviceModelCopiers.enumToStringCopyMethodName()).addCode(this.enumToStringCopyMethodBody()).build();
    }

    private TypeName paramaterTypeForEnumToStringCopyMethod() {
        TypeName typeName = null;
        if (this.memberModel.isList()) {
            typeName = this.typeProvider.listWithEnumParameterType(this.memberModel);
        } else if (this.memberModel.isMap()) {
            typeName = this.typeProvider.mapWithEnumParameterType(this.memberModel.getMapModel());
        }
        return typeName;
    }

    private CodeBlock enumToStringCopyMethodBody() {
        if (this.memberModel.isList()) {
            return this.listCopyBody(true);
        }
        if (this.memberModel.isMap()) {
            return this.mapCopyBody(true);
        }
        return null;
    }

    private MethodSpec builderCopyMethod() {
        if (this.memberModel.isList()) {
            return this.builderCopyMethodForList();
        }
        if (this.memberModel.isMap()) {
            return this.builderCopyMethodForMap();
        }
        throw new UnsupportedOperationException();
    }

    private MethodSpec builderCopyMethodForMap() {
        TypeName keyType = this.typeProvider.getTypeNameForSimpleType(this.memberModel.getMapModel().getKeyModel().getVariable().getVariableType());
        ClassName valueParameter = this.poetExtensions.getModelClass(this.memberModel.getMapModel().getValueModel().getC2jShape());
        ClassName builderForParameter = valueParameter.nestedClass("Builder");
        ParameterizedTypeName parameterType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyType, WildcardTypeName.subtypeOf((TypeName)builderForParameter)});
        CodeBlock code = CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $N($N.entrySet().stream().collect(toMap($T::getKey, e -> e.getValue().build())))", new Object[]{this.serviceModelCopiers.copyMethodName(), this.memberParamName(), Map.Entry.class}).build();
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.builderCopyMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter((TypeName)parameterType, this.memberParamName(), new Modifier[0]).returns(this.typeProvider.fieldType(this.memberModel)).addCode(code).build();
    }

    private MethodSpec builderCopyMethodForList() {
        ClassName listParameter = this.poetExtensions.getModelClass(this.memberModel.getListModel().getListMemberModel().getC2jShape());
        ClassName builderForParameter = listParameter.nestedClass("Builder");
        ParameterizedTypeName parameterType = ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)builderForParameter)});
        CodeBlock code = CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $N($N.stream().map($T::$N).collect(toList()))", new Object[]{this.serviceModelCopiers.copyMethodName(), this.memberParamName(), builderForParameter, "build"}).build();
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.builderCopyMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter((TypeName)parameterType, this.memberParamName(), new Modifier[0]).returns(this.typeProvider.fieldType(this.memberModel)).addCode(code).build();
    }

    private CodeBlock copyMethodBody() {
        if (this.memberModel.isMap()) {
            return this.mapCopyBody(false);
        }
        if (this.memberModel.isList()) {
            return this.listCopyBody(false);
        }
        return this.modelCopyBody();
    }

    private CodeBlock listCopyBody(boolean checkForModeledEnum) {
        String paramName = this.memberParamName();
        MemberModel listMember = this.memberModel.getListModel().getListMemberModel();
        String copyName = paramName + "Copy";
        CodeBlock.Builder builder = CodeBlock.builder();
        if (this.typeProvider.useAutoConstructLists()) {
            builder.beginControlFlow("if ($1N == null || $1N instanceof $2T)", new Object[]{this.memberParamName(), SdkAutoConstructList.class}).addStatement("return $T.getInstance()", new Object[]{DefaultSdkAutoConstructList.class}).endControlFlow();
        } else {
            builder.beginControlFlow("if ($N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow();
        }
        Optional<ClassName> elementCopier = this.serviceModelCopiers.copierClassFor(listMember);
        if (checkForModeledEnum && listMember.getEnumType() != null) {
            builder.addStatement("$T $N = $N.stream().map(Object::toString).collect(toList())", new Object[]{this.typeProvider.fieldType(this.memberModel), copyName, paramName});
        } else if (!elementCopier.isPresent()) {
            builder.addStatement("$T $N = new $T<>($N)", new Object[]{this.typeProvider.fieldType(this.memberModel), copyName, this.typeProvider.listImplClassName(), paramName});
        } else {
            ClassName copier = elementCopier.get();
            builder.addStatement("$T $N = $N.stream().map($T::$N).collect(toList())", new Object[]{this.typeProvider.fieldType(this.memberModel), copyName, paramName, copier, this.serviceModelCopiers.copyMethodName()});
        }
        builder.addStatement("return $T.unmodifiableList($N)", new Object[]{Collections.class, copyName});
        return builder.build();
    }

    private CodeBlock mapCopyBody(boolean checkForModeledEnum) {
        MapModel mapModel = this.memberModel.getMapModel();
        String copyMethod = this.serviceModelCopiers.copyMethodName();
        String paramName = this.memberParamName();
        String copyName = paramName + "Copy";
        CodeBlock keyCopyExpr = Optional.ofNullable(mapModel.getKeyModel()).map(model -> this.serviceModelCopiers.copierClassFor((MemberModel)model).map(copier -> CodeBlock.of((String)"e -> $T.$N(e.getKey())", (Object[])new Object[]{copier, copyMethod})).orElseGet(() -> checkForModeledEnum && model.getEnumType() != null ? CodeBlock.of((String)"e -> e.getKey().toString()", (Object[])new Object[0]) : CodeBlock.of((String)"$T::getKey", (Object[])new Object[]{Map.Entry.class}))).orElseGet(() -> CodeBlock.of((String)"e -> $T.$N(e.getKey())", (Object[])new Object[]{StandardMemberCopier.class, copyMethod}));
        CodeBlock valueCopyExpr = Optional.ofNullable(mapModel.getValueModel()).map(model -> this.serviceModelCopiers.copierClassFor((MemberModel)model).map(copier -> CodeBlock.of((String)"e -> $T.$N(e.getValue())", (Object[])new Object[]{copier, copyMethod})).orElseGet(() -> checkForModeledEnum && model.getEnumType() != null ? CodeBlock.of((String)"e -> e.getValue().toString()", (Object[])new Object[0]) : CodeBlock.of((String)"$T::getValue", (Object[])new Object[]{Map.Entry.class}))).orElseGet(() -> CodeBlock.of((String)"e -> $T.$N(e.getValue())", (Object[])new Object[]{StandardMemberCopier.class, copyMethod}));
        CodeBlock.Builder builder = CodeBlock.builder();
        if (this.typeProvider.useAutoConstructMaps()) {
            builder.beginControlFlow("if ($1N == null || $1N instanceof $2T)", new Object[]{this.memberParamName(), SdkAutoConstructMap.class}).addStatement("return $T.getInstance()", new Object[]{DefaultSdkAutoConstructMap.class}).endControlFlow();
        } else {
            builder.beginControlFlow("if ($1N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow();
        }
        builder.addStatement("$T $N = $N.entrySet().stream().collect(toMap($L, $L))", new Object[]{this.typeProvider.fieldType(this.memberModel), copyName, this.memberParamName(), keyCopyExpr, valueCopyExpr});
        return builder.addStatement("return $T.unmodifiableMap($N)", new Object[]{Collections.class, copyName}).build();
    }

    private CodeBlock modelCopyBody() {
        return CodeBlock.builder().addStatement("return $N", new Object[]{this.memberParamName()}).build();
    }

    private String memberParamName() {
        if (this.memberModel.isSimple()) {
            return Utils.unCapitalize(this.memberModel.getVariable().getSimpleType()) + "Param";
        }
        return Utils.unCapitalize(this.memberModel.getC2jShape()) + "Param";
    }
}

