/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.transform;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.utils.Validate;

public class JsonModelMarshallerSpec
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final ShapeModel shapeModel;
    private final ClassName className;
    private final ClassName requestClassName;

    public JsonModelMarshallerSpec(IntermediateModel intermediateModel, ShapeModel shapeModel, String className) {
        PoetExtensions poetExtensions = new PoetExtensions(intermediateModel);
        String modelPackage = intermediateModel.getMetadata().getFullModelPackageName();
        this.intermediateModel = intermediateModel;
        this.shapeModel = shapeModel;
        this.className = poetExtensions.getTransformClass(shapeModel.getShapeName() + className);
        this.requestClassName = ClassName.get((String)modelPackage, (String)shapeModel.getShapeName(), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        return TypeSpec.classBuilder((ClassName)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(PoetUtils.generatedAnnotation()).addAnnotation(SdkInternalApi.class).addJavadoc("{@link $T} Marshaller", new Object[]{this.requestClassName}).addFields(this.memberVariables()).addMethods(this.methods()).build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private List<MethodSpec> methods() {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        methodSpecs.add(this.constructor());
        methodSpecs.add(this.getInstanceMethod());
        methodSpecs.add(this.marshallMethod());
        return methodSpecs;
    }

    private List<FieldSpec> memberVariables() {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        FieldSpec instance = FieldSpec.builder((TypeName)this.className, (String)"INSTANCE", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("new $T()", new Object[]{this.className}).build();
        for (MemberModel memberModel : this.shapeModel.getNonStreamingMembers()) {
            ParameterizedTypeName typeName = ParameterizedTypeName.get((ClassName)ClassName.get(MarshallingInfo.class), (TypeName[])new TypeName[]{this.marshallingTargetClass(memberModel.getMarshallingTargetClass(), memberModel.getVariable().getVariableType())});
            CodeBlock.Builder initializationCodeBlockBuilder = CodeBlock.builder().add("$T.builder($T.$L).marshallLocation($T.$L)", new Object[]{MarshallingInfo.class, MarshallingType.class, memberModel.getMarshallingType(), ClassName.get(MarshallLocation.class), memberModel.getHttp().getMarshallLocation()});
            if (memberModel.getHttp().getIsPayload()) {
                initializationCodeBlockBuilder.add(".isExplicitPayloadMember($L)", new Object[]{memberModel.getHttp().getIsPayload()});
            } else {
                initializationCodeBlockBuilder.add(".marshallLocationName($S)", new Object[]{memberModel.getHttp().getMarshallLocationName()});
            }
            initializationCodeBlockBuilder.add(".isBinary($L)", new Object[]{memberModel.getIsBinary()});
            Optional.ofNullable(this.intermediateModel.getCustomizationConfig().getModelMarshallerDefaultValueSupplier()).map(defaultValueSupplier -> (String)defaultValueSupplier.get(memberModel.getName())).ifPresent(value -> initializationCodeBlockBuilder.add(".defaultValueSupplier($L)", new Object[]{value}));
            if (memberModel.isIdempotencyToken()) {
                initializationCodeBlockBuilder.add(".defaultValueSupplier($T.getGenerator())", new Object[]{ClassName.get(IdempotentUtils.class)});
            }
            CodeBlock codeBlock = initializationCodeBlockBuilder.add(".build()", new Object[0]).build();
            FieldSpec fieldSpec = FieldSpec.builder((TypeName)typeName, (String)memberModel.getMarshallerBindingFieldName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(codeBlock).build();
            fields.add(fieldSpec);
        }
        fields.add(instance);
        return fields;
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private MethodSpec getInstanceMethod() {
        return MethodSpec.methodBuilder((String)"getInstance").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addStatement("return INSTANCE", new Object[0]).returns((TypeName)this.className).build();
    }

    private MethodSpec marshallMethod() {
        String variableName = this.shapeModel.getVariable().getVariableName();
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"marshall").addJavadoc("Marshall the given parameter object", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.requestClassName, variableName, new Modifier[0]).addParameter(ProtocolMarshaller.class, "protocolMarshaller", new Modifier[0]);
        if (this.shapeModel.getNonStreamingMembers().isEmpty()) {
            return methodSpecBuilder.build();
        }
        methodSpecBuilder.addStatement("$T.paramNotNull($L, $S)", new Object[]{ClassName.get(Validate.class), variableName, variableName});
        methodSpecBuilder.addStatement("$T.paramNotNull($L, $S)", new Object[]{ClassName.get(Validate.class), "protocolMarshaller", "protocolMarshaller"});
        methodSpecBuilder.beginControlFlow("try", new Object[0]);
        this.shapeModel.getNonStreamingMembers().forEach(memberModel -> methodSpecBuilder.addStatement("protocolMarshaller.marshall($L.$L(), $L)", new Object[]{variableName, memberModel.getFluentGetterMethodName(), memberModel.getMarshallerBindingFieldName()}));
        methodSpecBuilder.endControlFlow();
        methodSpecBuilder.beginControlFlow("catch (Exception e)", new Object[0]);
        methodSpecBuilder.addStatement("throw $T.builder().message(\"Unable to marshall request to JSON: \" + e.getMessage()).cause(e).build()", new Object[]{ClassName.get(SdkClientException.class)});
        methodSpecBuilder.endControlFlow();
        return methodSpecBuilder.build();
    }

    private ClassName marshallingTargetClass(String marshallerTargetClass, String variableType) {
        if ("List".equals(marshallerTargetClass)) {
            return ClassName.get(List.class);
        }
        if ("String".equals(marshallerTargetClass)) {
            return ClassName.get(String.class);
        }
        if ("Map".equals(marshallerTargetClass)) {
            return ClassName.get(Map.class);
        }
        if ("StructuredPojo".equals(marshallerTargetClass)) {
            return ClassName.get(StructuredPojo.class);
        }
        return ClassName.bestGuess((String)variableType);
    }
}

