/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.internal;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

public final class Jackson {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectWriter WRITER = MAPPER.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).writerWithDefaultPrettyPrinter();

    private Jackson() {
    }

    public static <T> T load(Class<T> clazz, File file) throws JsonParseException, JsonMappingException, IOException {
        return Jackson.load(clazz, new FileInputStream(file));
    }

    public static <T> T load(Class<T> clazz, InputStream is) throws JsonParseException, JsonMappingException, IOException {
        return (T)MAPPER.readValue(is, clazz);
    }

    public static <T> T load(Class<T> clazz, String fileLocation) throws JsonParseException, JsonMappingException, IOException {
        InputStream is = Jackson.class.getClassLoader().getResourceAsStream(fileLocation);
        return (T)MAPPER.readValue(is, clazz);
    }

    public static void write(Object value, Writer w) throws JsonGenerationException, JsonMappingException, IOException {
        WRITER.writeValue(w, value);
    }

    static {
        MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    }
}

