/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.docs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;
import software.amazon.awssdk.utils.async.SequentialSubscriber;

public class PaginationDocs {
    private static final String SUBSCRIBE_METHOD_NAME = "subscribe";
    private final OperationModel operationModel;
    private final PoetExtensions poetExtensions;

    public PaginationDocs(IntermediateModel intermediateModel, OperationModel operationModel) {
        this.operationModel = operationModel;
        this.poetExtensions = new PoetExtensions(intermediateModel);
    }

    public String getDocsForSyncOperation() {
        return CodeBlock.builder().add("<p>This is a variant of {@link #$L($T)} operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle making service calls for you.\n</p>", new Object[]{this.operationModel.getMethodName(), this.requestType()}).add("<p>\nWhen this operation is called, a custom iterable is returned but no service calls are made yet. So there is no guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response pages by making service calls until there are no pages left or your iteration stops. If there are errors in your request, you will see the failures only after you start iterating through the iterable.\n</p>", new Object[0]).add(this.getSyncCodeSnippets(), new Object[0]).build().toString();
    }

    public String getDocsForSyncResponseClass(ClassName clientInterface) {
        return CodeBlock.builder().add("<p>Represents the output for the {@link $T#$L($T)} operation which is a paginated operation. This class is an iterable of {@link $T} that can be used to iterate through all the response pages of the operation.</p>", new Object[]{clientInterface, this.getPaginatedMethodName(), this.requestType(), this.syncResponsePageType()}).add("<p>When the operation is called, an instance of this class is returned.  At this point, no service calls are made yet and so there is no guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response pages by making service calls until there are no pages left or your iteration stops. If there are errors in your request, you will see the failures only after you start iterating through the iterable.</p>", new Object[0]).add(this.getSyncCodeSnippets(), new Object[0]).build().toString();
    }

    public String getDocsForAsyncOperation() {
        return CodeBlock.builder().add("<p>This is a variant of {@link #$L($T)} operation. The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will internally handle making service calls for you.\n</p>", new Object[]{this.operationModel.getMethodName(), this.requestType()}).add("<p>When the operation is called, an instance of this class is returned.  At this point, no service calls are made yet and so there is no guarantee that the request is valid. If there are errors in your request, you will see the failures only after you start streaming the data. The subscribe method should be called as a request to start streaming data. For more info, see {@link $T#$L($T)}. Each call to the subscribe method will result in a new {@link $T} i.e., a new contract to stream data from the starting request.</p>", new Object[]{this.getPublisherType(), SUBSCRIBE_METHOD_NAME, this.getSubscriberType(), this.getSubscriptionType()}).add(this.getAsyncCodeSnippets(), new Object[0]).build().toString();
    }

    public String getDocsForAsyncResponseClass(ClassName clientInterface) {
        return CodeBlock.builder().add("<p>Represents the output for the {@link $T#$L($T)} operation which is a paginated operation. This class is a type of {@link $T} which can be used to provide a sequence of {@link $T} response pages as per demand from the subscriber.</p>", new Object[]{clientInterface, this.getPaginatedMethodName(), this.requestType(), this.getPublisherType(), this.syncResponsePageType()}).add("<p>When the operation is called, an instance of this class is returned.  At this point, no service calls are made yet and so there is no guarantee that the request is valid. If there are errors in your request, you will see the failures only after you start streaming the data. The subscribe method should be called as a request to start streaming data. For more info, see {@link $T#$L($T)}. Each call to the subscribe method will result in a new {@link $T} i.e., a new contract to stream data from the starting request.</p>", new Object[]{this.getPublisherType(), SUBSCRIBE_METHOD_NAME, this.getSubscriberType(), this.getSubscriptionType()}).add(this.getAsyncCodeSnippets(), new Object[0]).build().toString();
    }

    private String getSyncCodeSnippets() {
        CodeBlock callOperationOnClient = CodeBlock.builder().addStatement("$T responses = client.$L(request)", new Object[]{this.syncPaginatedResponseType(), this.getPaginatedMethodName()}).build();
        return CodeBlock.builder().add("\n\n<p>The following are few ways to iterate through the response pages:</p>", new Object[0]).add("1) Using a Stream", new Object[0]).add(this.buildCode(CodeBlock.builder().add(callOperationOnClient).addStatement("responses.stream().forEach(....)", new Object[0]).build())).add("\n\n2) Using For loop", new Object[0]).add(this.buildCode(CodeBlock.builder().add(callOperationOnClient).beginControlFlow("for ($T response : responses)", new Object[]{this.syncResponsePageType()}).addStatement(" // do something", new Object[0]).endControlFlow().build())).add("\n\n3) Use iterator directly", new Object[0]).add(this.buildCode(CodeBlock.builder().add(callOperationOnClient).addStatement("responses.iterator().forEachRemaining(....)", new Object[0]).build())).add(this.noteAboutSyncNonPaginatedMethod()).build().toString();
    }

    private String getAsyncCodeSnippets() {
        CodeBlock callOperationOnClient = CodeBlock.builder().addStatement("$T publisher = client.$L(request)", new Object[]{this.asyncPaginatedResponseType(), this.getPaginatedMethodName()}).build();
        return CodeBlock.builder().add("\n\n<p>The following are few ways to use the response class:</p>", new Object[0]).add("1) Using the forEach helper method", new Object[]{TypeName.get(SequentialSubscriber.class)}).add(this.buildCode(CodeBlock.builder().add(callOperationOnClient).add(CodeBlock.builder().addStatement("CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response })", new Object[0]).addStatement("future.get()", new Object[0]).build()).build())).add("\n\n2) Using a custom subscriber", new Object[0]).add(this.buildCode(CodeBlock.builder().add(callOperationOnClient).add("publisher.subscribe(new Subscriber<$T>() {\n\n", new Object[]{this.syncResponsePageType()}).addStatement("public void onSubscribe($T subscription) { //... }", new Object[]{this.getSubscriberType()}).add("\n\n", new Object[0]).addStatement("public void onNext($T response) { //... }", new Object[]{this.syncResponsePageType()}).add("});", new Object[0]).build())).add("As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.", new Object[0]).add(this.noteAboutSyncNonPaginatedMethod()).build().toString();
    }

    private CodeBlock buildCode(CodeBlock codeSnippet) {
        return CodeBlock.builder().add("<pre>{@code\n", new Object[0]).add(codeSnippet).add("}</pre>", new Object[0]).build();
    }

    private String getPaginatedMethodName() {
        return PaginatorUtils.getPaginatedMethodName(this.operationModel.getMethodName());
    }

    private ClassName requestType() {
        return this.poetExtensions.getModelClass(this.operationModel.getInput().getVariableType());
    }

    private ClassName syncResponsePageType() {
        return this.poetExtensions.getModelClass(this.operationModel.getReturnType().getReturnType());
    }

    private ClassName syncPaginatedResponseType() {
        return this.poetExtensions.getResponseClassForPaginatedSyncOperation(this.operationModel.getOperationName());
    }

    private ClassName asyncPaginatedResponseType() {
        return this.poetExtensions.getResponseClassForPaginatedAsyncOperation(this.operationModel.getOperationName());
    }

    private CodeBlock noteAboutSyncNonPaginatedMethod() {
        return CodeBlock.builder().add("\n<p><b>Note: If you prefer to have control on service calls, use the {@link #$L($T)} operation.</b></p>", new Object[]{this.operationModel.getMethodName(), this.requestType()}).build();
    }

    private ClassName getPublisherType() {
        return ClassName.get(Publisher.class);
    }

    private ClassName getSubscriberType() {
        return ClassName.get(Subscriber.class);
    }

    private ClassName getSubscriptionType() {
        return ClassName.get(Subscription.class);
    }
}

