/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.poet.builder.AsyncClientBuilderClass;
import software.amazon.awssdk.codegen.poet.builder.AsyncClientBuilderInterface;
import software.amazon.awssdk.codegen.poet.client.AsyncClientClass;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;

public class AsyncClientGeneratorTasks
extends BaseGeneratorTasks {
    private final GeneratorTaskParams generatorTaskParams;

    public AsyncClientGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.generatorTaskParams = dependencies;
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting Async client classes");
        return Arrays.asList(this.createClientClassTask(), this.createClientBuilderTask(), this.createClientBuilderInterfaceTask(), this.createClientInterfaceTask());
    }

    private GeneratorTask createClientClassTask() throws IOException {
        return this.createPoetGeneratorTask(new AsyncClientClass(this.generatorTaskParams));
    }

    private GeneratorTask createClientBuilderTask() throws IOException {
        return this.createPoetGeneratorTask(new AsyncClientBuilderClass(this.model));
    }

    private GeneratorTask createClientBuilderInterfaceTask() throws IOException {
        return this.createPoetGeneratorTask(new AsyncClientBuilderInterface(this.model));
    }

    private GeneratorTask createClientInterfaceTask() throws IOException {
        return this.createPoetGeneratorTask(new AsyncClientInterface(this.model));
    }
}

