/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.utils.CollectionUtils;

public final class BeanGetterHelper {
    private final PoetExtensions poetExtensions;
    private final TypeProvider typeProvider;

    public BeanGetterHelper(PoetExtensions poetExtensions, TypeProvider typeProvider) {
        this.poetExtensions = poetExtensions;
        this.typeProvider = typeProvider;
    }

    public MethodSpec beanStyleGetter(MemberModel memberModel) {
        if (memberModel.hasBuilder()) {
            return this.builderGetter(memberModel);
        }
        if (memberModel.isCollectionWithBuilderMember()) {
            return memberModel.isList() ? this.listOfBuildersGetter(memberModel) : this.mapOfBuildersGetter(memberModel);
        }
        return this.regularGetter(memberModel);
    }

    private MethodSpec regularGetter(MemberModel memberModel) {
        return this.basicGetter(memberModel, this.typeProvider.parameterType(memberModel), "return $N", memberModel.getVariable().getVariableName());
    }

    private MethodSpec builderGetter(MemberModel memberModel) {
        return this.basicGetter(memberModel, (TypeName)this.poetExtensions.getModelClass(memberModel.getC2jShape()).nestedClass("Builder"), "return $1N != null ? $1N.toBuilder() : null", memberModel.getVariable().getVariableName());
    }

    private MethodSpec mapOfBuildersGetter(MemberModel memberModel) {
        TypeName keyType = this.typeProvider.getTypeNameForSimpleType(memberModel.getMapModel().getKeyModel().getVariable().getVariableType());
        ClassName valueType = this.poetExtensions.getModelClass(memberModel.getMapModel().getValueModel().getC2jShape());
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyType, valueType.nestedClass("Builder")});
        return this.basicGetter(memberModel, (TypeName)returnType, "return $1N != null ? $2T.mapValues($1N, $3T::toBuilder) : null", memberModel.getVariable().getVariableName(), CollectionUtils.class, valueType);
    }

    private MethodSpec listOfBuildersGetter(MemberModel memberModel) {
        ClassName memberType = this.poetExtensions.getModelClass(memberModel.getListModel().getListMemberModel().getC2jShape());
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{memberType.nestedClass("Builder")});
        return this.basicGetter(memberModel, (TypeName)returnType, "return $1N != null ? $1N.stream().map($2T::toBuilder).collect($3T.toList()) : null", memberModel.getVariable().getVariableName(), memberType, Collectors.class);
    }

    private MethodSpec basicGetter(MemberModel memberModel, TypeName returnType, String statementCode, Object ... statementArgs) {
        return MethodSpec.methodBuilder((String)memberModel.getBeanStyleGetterMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(returnType).addStatement(statementCode, statementArgs).build();
    }
}

