/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.docs;

import java.util.Map;
import software.amazon.awssdk.codegen.docs.DocumentationBuilder;
import software.amazon.awssdk.codegen.docs.Factory;
import software.amazon.awssdk.codegen.docs.OperationDocProvider;
import software.amazon.awssdk.codegen.docs.SimpleMethodOverload;
import software.amazon.awssdk.codegen.internal.ImmutableMapParameter;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;
import software.amazon.awssdk.core.sync.StreamingResponseHandler;

class SyncOperationDocProvider
extends OperationDocProvider {
    private static final String DEFAULT_RETURN = "Result of the %s operation returned by the service.";
    private static final String REQUEST_BODY_DOCS = "The content to send to the service. A {@link RequestBody} can be created using one of several factory methods for various sources of data. For example, to create a request body from a file you can do the following. <pre>{@code RequestBody.of(new File(\"myfile.txt\"))}</pre>See documentation in {@link RequestBody} for additional details and which sources of data are supported. ";
    private static final String STREAM_RESPONSE_HANDLER_DOCS = "Functional interface for processing the streamed response content. The unmarshalled %s and an InputStream to the response content are provided as parameters to the callback. The callback may return a transformed type which will be the return value of this method. See {@link " + StreamingResponseHandler.class.getName() + "} for details on implementing this interface and for links to pre-canned implementations for common scenarios like downloading to a file. ";

    private SyncOperationDocProvider(IntermediateModel model, OperationModel opModel) {
        super(model, opModel);
    }

    @Override
    protected String getDefaultServiceDocs() {
        return String.format("Invokes the %s operation.", this.opModel.getOperationName());
    }

    @Override
    protected String getInterfaceName() {
        return this.model.getMetadata().getSyncInterface();
    }

    @Override
    protected void applyReturns(DocumentationBuilder docBuilder) {
        if (this.opModel.hasStreamingOutput()) {
            docBuilder.returns("The transformed result of the StreamingResponseHandler.");
        } else {
            docBuilder.returns(DEFAULT_RETURN, this.opModel.getOperationName());
        }
    }

    @Override
    protected void applyParams(DocumentationBuilder docBuilder) {
        this.emitRequestParm(docBuilder);
        if (this.opModel.hasStreamingInput()) {
            docBuilder.param("requestBody", REQUEST_BODY_DOCS + this.getStreamingInputDocs());
        }
        if (this.opModel.hasStreamingOutput()) {
            docBuilder.param("streamingHandler", STREAM_RESPONSE_HANDLER_DOCS + this.getStreamingOutputDocs(), this.opModel.getOutputShape().getShapeName(), this.getStreamingOutputDocs());
        }
    }

    @Override
    protected void applyThrows(DocumentationBuilder docBuilder) {
        docBuilder.syncThrows(this.getThrows());
    }

    static Map<SimpleMethodOverload, Factory> syncFactories() {
        return new ImmutableMapParameter.Builder<SimpleMethodOverload, Factory>().put(SimpleMethodOverload.NORMAL, SyncOperationDocProvider::new).put(SimpleMethodOverload.NO_ARG, (x$0, x$1) -> new SyncNoArg((IntermediateModel)x$0, (OperationModel)x$1)).put(SimpleMethodOverload.FILE, (x$0, x$1) -> new SyncFile((IntermediateModel)x$0, (OperationModel)x$1)).put(SimpleMethodOverload.INPUT_STREAM, (x$0, x$1) -> new SyncInputStream((IntermediateModel)x$0, (OperationModel)x$1)).put(SimpleMethodOverload.BYTES, (x$0, x$1) -> new SyncBytes((IntermediateModel)x$0, (OperationModel)x$1)).put(SimpleMethodOverload.PAGINATED, (x$0, x$1) -> new SyncPaginated((IntermediateModel)x$0, (OperationModel)x$1)).put(SimpleMethodOverload.NO_ARG_PAGINATED, (x$0, x$1) -> new SyncPaginatedNoArg((IntermediateModel)x$0, (OperationModel)x$1)).build();
    }

    private static class SyncPaginatedNoArg
    extends SyncPaginated {
        private SyncPaginatedNoArg(IntermediateModel model, OperationModel opModel) {
            super(model, opModel);
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
            docBuilder.see("#%s(%s)", PaginatorUtils.getSyncMethodName(this.opModel.getMethodName()), this.opModel.getInput().getVariableType());
        }
    }

    private static class SyncPaginated
    extends SyncOperationDocProvider {
        private SyncPaginated(IntermediateModel model, OperationModel opModel) {
            super(model, opModel);
        }

        @Override
        protected String appendToDescription() {
            return this.opModel.isPaginated() ? this.paginationDocs.getDocsForSyncOperation() : null;
        }
    }

    private static class SyncNoArg
    extends SyncOperationDocProvider {
        private SyncNoArg(IntermediateModel model, OperationModel opModel) {
            super(model, opModel);
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
            docBuilder.see("#%s(%s)", this.opModel.getMethodName(), this.opModel.getInput().getVariableType());
        }
    }

    private static class SyncBytes
    extends SyncOperationDocProvider {
        private SyncBytes(IntermediateModel model, OperationModel opModel) {
            super(model, opModel);
        }

        @Override
        protected void applyReturns(DocumentationBuilder docBuilder) {
            docBuilder.returns("A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in convenient in-memory representations like a byte buffer or string. The unmarshalled response object can be obtained via {@link ResponseBytes#response()}. " + this.getStreamingOutputDocs());
            docBuilder.see("#getObject(%s, StreamingResponseHandler)", this.opModel.getMethodName(), this.opModel.getInput().getVariableType());
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
            this.emitRequestParm(docBuilder);
        }
    }

    private static class SyncInputStream
    extends SyncOperationDocProvider {
        private SyncInputStream(IntermediateModel model, OperationModel opModel) {
            super(model, opModel);
        }

        @Override
        protected void applyReturns(DocumentationBuilder docBuilder) {
            docBuilder.returns("A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior and exhausting connections in the connection pool. The unmarshalled response object can be obtained via {@link ResponseInputStream#response()}. " + this.getStreamingOutputDocs());
            docBuilder.see("#getObject(%s, StreamingResponseHandler)", this.opModel.getMethodName(), this.opModel.getInput().getVariableType());
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
            this.emitRequestParm(docBuilder);
        }
    }

    private static class SyncFile
    extends SyncOperationDocProvider {
        private SyncFile(IntermediateModel model, OperationModel opModel) {
            super(model, opModel);
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
            this.emitRequestParm(docBuilder);
            if (this.opModel.hasStreamingInput()) {
                docBuilder.param("path", "{@link Path} to file containing data to send to the service. File will be read entirely and may be read multiple times in the event of a retry. If the file does not exist or the current user does not have access to read it then an exception will be thrown. " + this.getStreamingInputDocs()).see("#%s(%s, RequestBody)", this.opModel.getMethodName(), this.opModel.getInput().getVariableType());
            }
            if (this.opModel.hasStreamingOutput()) {
                docBuilder.param("path", "{@link Path} to file that response contents will be written to. The file must not exist or this method will throw an exception. If the file is not writable by the current user then an exception will be thrown. " + this.getStreamingOutputDocs()).see("#%s(%s, StreamingResponseHandler)", this.opModel.getMethodName(), this.opModel.getInput().getVariableType());
            }
        }
    }
}

