/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.config.customization.OperationModifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.customization.ArtificialResultWrapper;
import software.amazon.awssdk.codegen.model.service.Member;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;
import software.amazon.awssdk.codegen.model.service.ShapeTypes;

final class OperationModifiersProcessor
implements CodegenCustomizationProcessor {
    private final Map<String, OperationModifier> operationModifiers;
    private final Set<String> createdWrapperShapes = new HashSet<String>();

    OperationModifiersProcessor(Map<String, OperationModifier> operationModifiers) {
        this.operationModifiers = operationModifiers;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
        if (this.operationModifiers == null) {
            return;
        }
        for (Map.Entry<String, OperationModifier> entry : this.operationModifiers.entrySet()) {
            String operationName = entry.getKey();
            OperationModifier modifier = entry.getValue();
            if (modifier.isExclude()) {
                this.preprocessExclude(serviceModel, operationName);
                continue;
            }
            if (!modifier.isUseWrappingResult()) continue;
            String createdWrapperShape = this.preprocessCreateResultWrapperShape(serviceModel, operationName, modifier);
            this.createdWrapperShapes.add(createdWrapperShape);
        }
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        if (this.operationModifiers == null) {
            return;
        }
        for (ShapeModel shape : intermediateModel.getShapes().values()) {
            if (!this.createdWrapperShapes.contains(shape.getC2jName())) continue;
            if (shape.getMembers().size() != 1) {
                throw new IllegalStateException("Result wrapper " + shape.getShapeName() + " has not just one member!");
            }
            MemberModel wrappedMember = shape.getMembers().get(0);
            shape.getCustomization().setArtificialResultWrapper(this.createArtificialResultWrapperInfo(shape, wrappedMember));
        }
    }

    private void preprocessExclude(ServiceModel serviceModel, String operationName) {
        serviceModel.getOperations().remove(operationName);
    }

    private String preprocessCreateResultWrapperShape(ServiceModel serviceModel, String operationName, OperationModifier modifier) {
        String wrappedShapeName = modifier.getWrappedResultShape();
        Shape wrappedShape = serviceModel.getShapes().get(wrappedShapeName);
        String wrapperShapeName = operationName + "Response";
        String wrappedAsMember = modifier.getWrappedResultMember();
        if (serviceModel.getShapes().containsKey(wrapperShapeName)) {
            throw new IllegalStateException(wrapperShapeName + " shape already exists in the service model.");
        }
        Shape wrapperShape = this.createWrapperShape(wrapperShapeName, wrappedShapeName, wrappedShape, wrappedAsMember);
        serviceModel.getShapes().put(wrapperShapeName, wrapperShape);
        Operation operation = serviceModel.getOperations().get(operationName);
        operation.getOutput().setShape(wrapperShapeName);
        return wrapperShapeName;
    }

    private Shape createWrapperShape(String wrapperShapeName, String wrappedShapeName, Shape wrapped, String wrappedAsMember) {
        Shape wrapper = new Shape();
        wrapper.setType(ShapeTypes.Structure.getName());
        wrapper.setDocumentation("A simple result wrapper around the " + wrappedShapeName + " object that was sent over the wire.");
        Member member = new Member();
        member.setShape(wrappedShapeName);
        member.setDocumentation(wrapped.getDocumentation());
        wrapper.setMembers(Collections.singletonMap(wrappedAsMember, member));
        return wrapper;
    }

    private ArtificialResultWrapper createArtificialResultWrapperInfo(ShapeModel shape, MemberModel wrappedMember) {
        ArtificialResultWrapper wrapper = new ArtificialResultWrapper();
        wrapper.setWrappedMemberName(wrappedMember.getName());
        wrapper.setWrappedMemberSimpleType(wrappedMember.getVariable().getSimpleType());
        return wrapper;
    }
}

