/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.ClientClassUtils;
import software.amazon.awssdk.codegen.poet.client.SyncClientClass;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.SdkAsyncClientHandler;
import software.amazon.awssdk.core.config.AsyncClientConfiguration;

public final class AsyncClientClass
extends AsyncClientInterface {
    private final PoetExtensions poetExtensions;
    private final ClassName className;
    private final ProtocolSpec protocolSpec;
    private final String basePackage;

    public AsyncClientClass(GeneratorTaskParams dependencies) {
        super(dependencies.getModel());
        this.poetExtensions = dependencies.getPoetExtensions();
        this.className = this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncClient());
        this.protocolSpec = SyncClientClass.getProtocolSpecs(this.poetExtensions, this.model.getMetadata().getProtocol());
        this.basePackage = dependencies.getModel().getMetadata().getFullClientPackageName();
    }

    @Override
    public TypeSpec poetSpec() {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface());
        TypeSpec.Builder classBuilder = PoetUtils.createClassBuilder(this.className).addAnnotation(SdkInternalApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addField(AsyncClientHandler.class, "clientHandler", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(this.protocolSpec.protocolFactory(this.model)).addSuperinterface((TypeName)interfaceClass).addJavadoc("Internal implementation of {@link $1T}.\n\n@see $1T#builder()", new Object[]{interfaceClass}).addMethods(this.operations()).addMethod(this.closeMethod()).addMethods(this.protocolSpec.additionalMethods()).addMethod(this.protocolSpec.initProtocolFactory(this.model));
        if (this.model.getCustomizationConfig().getServiceSpecificClientConfigClass() != null) {
            classBuilder.addMethod(this.constructorWithAdvancedConfiguration());
        } else {
            classBuilder.addMethod(this.constructor());
        }
        this.protocolSpec.createErrorResponseHandler().ifPresent(arg_0 -> ((TypeSpec.Builder)classBuilder).addMethod(arg_0));
        return classBuilder.build();
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(AsyncClientConfiguration.class, "clientConfiguration", new Modifier[0]).addStatement("this.clientHandler = new $T(clientConfiguration, null)", new Object[]{SdkAsyncClientHandler.class}).addStatement("this.$N = init()", new Object[]{this.protocolSpec.protocolFactory((IntermediateModel)this.model).name}).build();
    }

    private MethodSpec constructorWithAdvancedConfiguration() {
        ClassName advancedConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceSpecificClientConfigClass(), (String[])new String[0]);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(AsyncClientConfiguration.class, "clientConfiguration", new Modifier[0]).addParameter((TypeName)advancedConfiguration, "serviceConfiguration", new Modifier[0]).addStatement("this.clientHandler = new $T(clientConfiguration, serviceConfiguration)", new Object[]{SdkAsyncClientHandler.class}).addStatement("this.$N = init()", new Object[]{this.protocolSpec.protocolFactory((IntermediateModel)this.model).name}).build();
    }

    private MethodSpec closeMethod() {
        return MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$N.close()", new Object[]{"clientHandler"}).build();
    }

    @Override
    protected MethodSpec.Builder operationBody(MethodSpec.Builder builder, OperationModel opModel) {
        ClassName returnType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        return builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(ClientClassUtils.getCustomResponseHandler(opModel, returnType).orElseGet(() -> this.protocolSpec.responseHandler(opModel))).addCode(this.protocolSpec.errorResponseHandler(opModel)).addCode(this.protocolSpec.asyncExecutionHandler(opModel));
    }

    @Override
    public ClassName className() {
        return this.className;
    }
}

