/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.docs.SimpleMethodOverload;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.ClientClassUtils;
import software.amazon.awssdk.codegen.poet.client.SyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.specs.Ec2ProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.JsonProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.QueryXmlProtocolSpec;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;

public class SyncClientClass
implements ClassSpec {
    private final IntermediateModel model;
    private final String basePackage;
    private final PoetExtensions poetExtensions;
    private final ClassName className;
    private final ProtocolSpec protocolSpec;

    public SyncClientClass(GeneratorTaskParams taskParams) {
        this.model = taskParams.getModel();
        this.basePackage = this.model.getMetadata().getFullClientPackageName();
        this.poetExtensions = taskParams.getPoetExtensions();
        this.className = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncClient());
        this.protocolSpec = SyncClientClass.getProtocolSpecs(this.poetExtensions, this.model.getMetadata().getProtocol());
    }

    @Override
    public TypeSpec poetSpec() {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncInterface());
        TypeSpec.Builder classBuilder = PoetUtils.createClassBuilder(this.className).addAnnotation(SdkInternalApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface((TypeName)interfaceClass).addJavadoc("Internal implementation of {@link $1T}.\n\n@see $1T#builder()", new Object[]{interfaceClass}).addField(ClientHandler.class, "clientHandler", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(this.protocolSpec.protocolFactory(this.model)).addField(ClientConfiguration.class, "clientConfiguration", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethods(this.operations());
        if (this.model.getCustomizationConfig().getServiceSpecificClientConfigClass() != null) {
            classBuilder.addMethod(this.constructorWithAdvancedConfiguration());
        } else {
            classBuilder.addMethod(this.constructor());
        }
        this.protocolSpec.createErrorResponseHandler().ifPresent(arg_0 -> ((TypeSpec.Builder)classBuilder).addMethod(arg_0));
        classBuilder.addMethod(this.protocolSpec.initProtocolFactory(this.model));
        classBuilder.addMethod(this.closeMethod());
        classBuilder.addMethods(this.protocolSpec.additionalMethods());
        return classBuilder.build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(SyncClientConfiguration.class, "clientConfiguration", new Modifier[0]).addStatement("this.clientHandler = new $T(clientConfiguration, null)", new Object[]{this.protocolSpec.getClientHandlerClass()}).addStatement("this.$N = init()", new Object[]{this.protocolSpec.protocolFactory((IntermediateModel)this.model).name}).addStatement("this.clientConfiguration = clientConfiguration", new Object[0]).build();
    }

    private MethodSpec constructorWithAdvancedConfiguration() {
        ClassName advancedConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceSpecificClientConfigClass(), (String[])new String[0]);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(SyncClientConfiguration.class, "clientConfiguration", new Modifier[0]).addParameter((TypeName)advancedConfiguration, "serviceConfiguration", new Modifier[0]).addStatement("this.clientHandler = new $T(clientConfiguration, serviceConfiguration)", new Object[]{this.protocolSpec.getClientHandlerClass()}).addStatement("this.$N = init()", new Object[]{this.protocolSpec.protocolFactory((IntermediateModel)this.model).name}).addStatement("this.clientConfiguration = clientConfiguration", new Object[0]).build();
    }

    private List<MethodSpec> operations() {
        return this.model.getOperations().values().stream().map(this::operationMethodSpecs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<MethodSpec> operationMethodSpecs(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        ClassName returnType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        methods.add(SyncClientInterface.operationMethodSignature(this.model, opModel).addAnnotation(Override.class).addCode(ClientClassUtils.getCustomResponseHandler(opModel, returnType).orElseGet(() -> this.protocolSpec.responseHandler(opModel))).addCode(this.protocolSpec.errorResponseHandler(opModel)).addCode(this.protocolSpec.executionHandler(opModel)).build());
        methods.addAll(this.paginatedMethods(opModel));
        return methods;
    }

    private List<MethodSpec> paginatedMethods(OperationModel opModel) {
        ArrayList<MethodSpec> paginatedMethodSpecs = new ArrayList<MethodSpec>();
        if (opModel.isPaginated()) {
            paginatedMethodSpecs.add(SyncClientInterface.operationMethodSignature(this.model, opModel, SimpleMethodOverload.PAGINATED, PaginatorUtils.getSyncMethodName(opModel.getMethodName())).addAnnotation(Override.class).returns((TypeName)this.poetExtensions.getResponseClassForPaginatedSyncOperation(opModel.getOperationName())).addStatement("return new $T(this, $L)", new Object[]{this.poetExtensions.getResponseClassForPaginatedSyncOperation(opModel.getOperationName()), opModel.getInput().getVariableName()}).build());
        }
        return paginatedMethodSpecs;
    }

    private MethodSpec closeMethod() {
        return MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addStatement("clientHandler.close()", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
    }

    static ProtocolSpec getProtocolSpecs(PoetExtensions poetExtensions, Protocol protocol) {
        switch (protocol) {
            case QUERY: 
            case REST_XML: {
                return new QueryXmlProtocolSpec(poetExtensions);
            }
            case EC2: {
                return new Ec2ProtocolSpec(poetExtensions);
            }
            case AWS_JSON: 
            case REST_JSON: 
            case CBOR: 
            case ION: {
                return new JsonProtocolSpec(poetExtensions);
            }
            case API_GATEWAY: {
                throw new UnsupportedOperationException("Not yet supported.");
            }
        }
        throw new RuntimeException("Unknown protocol: " + protocol.name());
    }
}

