/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.core.client.builder.SyncClientBuilder;

public class SyncClientBuilderInterface
implements ClassSpec {
    private final ClassName builderInterfaceName;
    private final ClassName clientInterfaceName;
    private final ClassName baseBuilderInterfaceName;

    public SyncClientBuilderInterface(IntermediateModel model) {
        String basePackage = model.getMetadata().getFullClientPackageName();
        this.clientInterfaceName = ClassName.get((String)basePackage, (String)model.getMetadata().getSyncInterface(), (String[])new String[0]);
        this.builderInterfaceName = ClassName.get((String)basePackage, (String)model.getMetadata().getSyncBuilderInterface(), (String[])new String[0]);
        this.baseBuilderInterfaceName = ClassName.get((String)basePackage, (String)model.getMetadata().getBaseBuilderInterface(), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        return PoetUtils.createInterfaceBuilder(this.builderInterfaceName).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SyncClientBuilder.class), (TypeName[])new TypeName[]{this.builderInterfaceName, this.clientInterfaceName})).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)this.baseBuilderInterfaceName, (TypeName[])new TypeName[]{this.builderInterfaceName, this.clientInterfaceName})).addJavadoc(this.getJavadoc()).build();
    }

    @Override
    public ClassName className() {
        return this.builderInterfaceName;
    }

    private CodeBlock getJavadoc() {
        return CodeBlock.of((String)"A builder for creating an instance of {@link $1T}. This can be created with the static {@link $1T#builder()} method.", (Object[])new Object[]{this.clientInterfaceName});
    }
}

