/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.CodeWriter;
import software.amazon.awssdk.codegen.emitters.FreemarkerGeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;

public class SmokeTestsGeneratorTasks
extends BaseGeneratorTasks {
    private final String smokeTestsPackageDir;

    public SmokeTestsGeneratorTasks(GeneratorTaskParams params) {
        super(params);
        this.smokeTestsPackageDir = params.getPathProvider().getSmokeTestDirectory();
    }

    @Override
    protected boolean hasTasks() {
        return !this.model.getCustomizationConfig().isSkipSmokeTests();
    }

    @Override
    public List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting smoke test files");
        return Arrays.asList(new FreemarkerGeneratorTask(this.smokeTestsPackageDir, this.model.getMetadata().getCucumberModuleInjectorClassName(), this.freemarker.getCucumberModuleInjectorTemplate(), this.model), new FreemarkerGeneratorTask(this.smokeTestsPackageDir, "RunCucumberTest", this.freemarker.getCucumberTestTemplate(), this.model), new FreemarkerGeneratorTask(new CodeWriter(this.smokeTestsPackageDir, "cucumber", ".properties"), this.freemarker.getCucumberPropertiesTemplate(), this.model));
    }
}

