/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.config.customization.SimpleMethodFormsWrapper;
import software.amazon.awssdk.codegen.model.intermediate.ArgumentModel;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.service.ServiceModel;

final class SimpleMethodsProcessor
implements CodegenCustomizationProcessor {
    private final Map<String, SimpleMethodFormsWrapper> simpleMethods;

    SimpleMethodsProcessor(Map<String, SimpleMethodFormsWrapper> simpleMethods) {
        this.simpleMethods = simpleMethods;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        if (this.simpleMethods == null) {
            return;
        }
        Map<String, OperationModel> operationModels = intermediateModel.getOperations();
        Map<String, ShapeModel> shapeModels = intermediateModel.getShapes();
        for (Map.Entry<String, SimpleMethodFormsWrapper> entry : this.simpleMethods.entrySet()) {
            String operationName = entry.getKey();
            SimpleMethodFormsWrapper methodFormsWrapper = entry.getValue();
            OperationModel opModel = operationModels.get(operationName);
            if (opModel == null) {
                throw new RuntimeException("Simple Method forms customization present for an unknown operation " + operationName);
            }
            String inputShapeName = opModel.getInput().getSimpleType();
            ShapeModel shape = shapeModels.get(inputShapeName);
            List<List<String>> methodForms = methodFormsWrapper.getMethodForms();
            for (List<String> argumentList : methodForms) {
                ArrayList<ArgumentModel> simplifiedForm = new ArrayList<ArgumentModel>();
                for (String argument : argumentList) {
                    ArgumentModel argModel = new ArgumentModel();
                    MemberModel memberModel = shape.findMemberModelByC2jName(argument);
                    argModel.setDocumentation(memberModel.getDocumentation());
                    argModel.setName(memberModel.getVariable().getVariableName());
                    argModel.setType(memberModel.getVariable().getVariableType());
                    simplifiedForm.add(argModel);
                }
                opModel.addSimpleMethodForm(simplifiedForm);
            }
        }
    }
}

