/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.MemberCopierSpec;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.runtime.StandardMemberCopier;

public class ServiceModelCopiers {
    private final IntermediateModel intermediateModel;
    private final PoetExtensions poetExtensions;
    private final TypeProvider typeProvider;

    public ServiceModelCopiers(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.poetExtensions = new PoetExtensions(intermediateModel);
        this.typeProvider = new TypeProvider(intermediateModel);
    }

    public Collection<ClassSpec> copierSpecs() {
        HashMap memberSpecs = new HashMap();
        this.allShapeMembers().values().stream().filter(m -> !this.canCopyReference((MemberModel)m) && !this.canUseStandardCopier((MemberModel)m)).map(m -> new MemberCopierSpec((MemberModel)m, this, this.typeProvider)).forEach(spec -> {
            ClassSpec cfr_ignored_0 = memberSpecs.put(spec.className(), spec);
        });
        return memberSpecs.values();
    }

    public Optional<ClassName> copierClassFor(MemberModel memberModel) {
        if (this.canCopyReference(memberModel)) {
            return Optional.empty();
        }
        if (this.canUseStandardCopier(memberModel)) {
            return Optional.of(ClassName.get(StandardMemberCopier.class));
        }
        String shapeName = memberModel.getC2jShape();
        if (shapeName.substring(0, 1).toLowerCase(Locale.ENGLISH).equals(shapeName.substring(0, 1))) {
            shapeName = "_" + shapeName;
        }
        return Optional.of(this.poetExtensions.getModelClass(shapeName + "Copier"));
    }

    public String copyMethodName() {
        return "copy";
    }

    private Map<String, MemberModel> allShapeMembers() {
        HashMap shapeMembers = new HashMap();
        this.intermediateModel.getShapes().values().stream().flatMap(s -> s.getMembersAsMap().values().stream()).forEach(m -> shapeMembers.put(m.getC2jShape(), m));
        HashMap<String, MemberModel> allMembers = new HashMap<String, MemberModel>(shapeMembers);
        shapeMembers.values().forEach(m -> this.putMembersOfMember((MemberModel)m, (Map<String, MemberModel>)allMembers));
        return allMembers;
    }

    private void putMembersOfMember(MemberModel memberModel, Map<String, MemberModel> allMembers) {
        MapModel mapModel;
        if (memberModel.isList()) {
            MemberModel listMember = memberModel.getListModel().getListMemberModel();
            allMembers.put(listMember.getC2jShape(), listMember);
            this.putMembersOfMember(listMember, allMembers);
        } else if (memberModel.isMap() && !(mapModel = memberModel.getMapModel()).isValueSimple()) {
            MemberModel valueMember = mapModel.getValueModel();
            allMembers.put(valueMember.getC2jShape(), valueMember);
            this.putMembersOfMember(valueMember, allMembers);
        }
    }

    private boolean canUseStandardCopier(MemberModel m) {
        if (m.isList() || m.isMap() || !m.isSimple()) {
            return false;
        }
        String simpleType = m.getVariable().getSimpleType();
        return "Date".equals(simpleType) || "ByteBuffer".equals(simpleType);
    }

    private boolean canCopyReference(MemberModel m) {
        if (m.isList() || m.isMap()) {
            return false;
        }
        if (m.isSimple()) {
            String simpleType;
            switch (simpleType = m.getVariable().getSimpleType()) {
                case "Date": 
                case "ByteBuffer": {
                    return false;
                }
            }
            return true;
        }
        return true;
    }
}

