/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.model.MemberSetters;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

abstract class AbstractMemberSetters
implements MemberSetters {
    private final ShapeModel shapeModel;
    private final MemberModel memberModel;
    private final IntermediateModel intermediateModel;
    private final TypeProvider typeProvider;
    private final ServiceModelCopiers serviceModelCopiers;

    AbstractMemberSetters(IntermediateModel intermediateModel, ShapeModel shapeModel, MemberModel memberModel, TypeProvider typeProvider) {
        this.shapeModel = shapeModel;
        this.memberModel = memberModel;
        this.intermediateModel = intermediateModel;
        this.typeProvider = typeProvider;
        this.serviceModelCopiers = new ServiceModelCopiers(intermediateModel);
    }

    protected MethodSpec.Builder fluentSetterDeclaration(ParameterSpec parameter, TypeName returnType) {
        return MethodSpec.methodBuilder((String)this.memberModel().getFluentSetterMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(parameter).returns(returnType);
    }

    protected MethodSpec.Builder fluentSetterBuilder(TypeName returnType) {
        return this.fluentSetterBuilder(this.memberAsParameter(), returnType);
    }

    protected MethodSpec.Builder fluentSetterBuilder(ParameterSpec setterParam, TypeName returnType) {
        return MethodSpec.methodBuilder((String)this.memberModel().getFluentSetterMethodName()).addParameter(setterParam).addAnnotation(Override.class).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }

    protected MethodSpec.Builder beanStyleSetterBuilder() {
        return this.beanStyleSetterBuilder(this.memberAsParameter());
    }

    protected MethodSpec.Builder beanStyleSetterBuilder(ParameterSpec setterParam) {
        return MethodSpec.methodBuilder((String)this.memberModel().getBeanStyleSetterMethodName()).addParameter(setterParam).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }

    protected CodeBlock copySetterBody() {
        Optional<ClassName> copierClass = this.serviceModelCopiers.copierClassFor(this.memberModel);
        return copierClass.map(className -> CodeBlock.builder().addStatement("this.$N = $T.$N($N)", new Object[]{this.fieldName(), className, this.serviceModelCopiers.copyMethodName(), this.fieldName()}).build()).orElseGet(() -> CodeBlock.builder().addStatement("this.$N = $N", new Object[]{this.fieldName(), this.fieldName()}).build());
    }

    protected ParameterSpec memberAsParameter() {
        return ParameterSpec.builder((TypeName)this.typeProvider.parameterType(this.memberModel), (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
    }

    protected ShapeModel shapeModel() {
        return this.shapeModel;
    }

    protected MemberModel memberModel() {
        return this.memberModel;
    }

    protected String fieldName() {
        return this.memberModel.getVariable().getVariableName();
    }

    protected boolean annotateJsonProperty() {
        return this.intermediateModel.getMetadata().isJsonProtocol() && this.shapeModel.getShapeType() == ShapeType.Exception;
    }
}

