/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.codegen.internal.Constants;
import software.amazon.awssdk.codegen.internal.DocumentationUtils;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.ArgumentModel;
import software.amazon.awssdk.codegen.model.intermediate.DocumentationModel;
import software.amazon.awssdk.codegen.model.intermediate.ExceptionModel;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.ReturnTypeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.SimpleMethodFormModel;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.StringUtils;

public class OperationModel
extends DocumentationModel {
    private String operationName;
    private boolean deprecated;
    private VariableModel input;
    private String inputStreamPropertyName;
    private ReturnTypeModel returnType;
    private List<ExceptionModel> exceptions = new ArrayList<ExceptionModel>();
    private List<SimpleMethodFormModel> simpleMethods;
    private boolean hasBlobMemberAsPayload;
    private boolean isAuthenticated = true;
    @JsonIgnore
    private ShapeModel inputShape;
    @JsonIgnore
    private ShapeModel outputShape;

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getMethodName() {
        return Utils.unCapitialize(this.operationName);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getSyncDocumentation(IntermediateModel model, OperationModel opModel) {
        return this.getDocumentation(MethodType.SYNC, model, opModel);
    }

    public String getAsyncDocumentation(IntermediateModel model, OperationModel opModel) {
        return this.getDocumentation(MethodType.ASYNC, model, opModel);
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setIsAuthenticated(boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
    }

    public ShapeModel getInputShape() {
        return this.inputShape;
    }

    public void setInputShape(ShapeModel inputShape) {
        this.inputShape = inputShape;
    }

    public ShapeModel getOutputShape() {
        return this.outputShape;
    }

    public void setOutputShape(ShapeModel outputShape) {
        this.outputShape = outputShape;
    }

    private String getDocumentation(MethodType methodType, IntermediateModel model, OperationModel opModel) {
        Object streamMemberDocs;
        Metadata md = model.getMetadata();
        StringBuilder docBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.documentation)) {
            docBuilder.append(this.documentation);
        } else {
            docBuilder.append("Invokes the ").append(this.operationName).append(" operation");
            if (methodType.isAsync()) {
                docBuilder.append(" asynchronously");
            }
            docBuilder.append(".");
        }
        if (this.input != null) {
            docBuilder.append(Constants.LF).append("@param ").append(this.input.getVariableName()).append(" ").append(DocumentationUtils.stripHtmlTags(this.input.getDocumentation()));
        }
        if (methodType == MethodType.ASYNC) {
            if (opModel.hasStreamingInput()) {
                streamMemberDocs = this.getStreamingMemberDocs(opModel.getInputShape());
                docBuilder.append(Constants.LF).append("@param requestProvider ").append("Functional interface that can be implemented to produce the request content ").append("in a non-blocking manner. The size of the content is expected to be known up front. ").append("See {@link AsyncRequestProvider} for specific details on implementing this interface as well ").append("as links to precanned implementations for common scenarios like uploading from a file. The ").append("service documentation for the request content is as follows '").append((String)streamMemberDocs).append("'.");
            }
            if (opModel.hasStreamingOutput()) {
                streamMemberDocs = this.getStreamingMemberDocs(opModel.getOutputShape());
                docBuilder.append(Constants.LF).append("@param asyncResponseHandler The response handler for processing the streaming response in a ").append("non-blocking manner. See {@link AsyncResponseHandler} for details on how this callback ").append("should be implemented and for links to precanned implementations for common scenarios like ").append("downloading to a file. The service documentation for the streamed content is as follows '").append((String)streamMemberDocs).append("'.");
            }
        } else if (methodType == MethodType.SYNC) {
            if (opModel.hasStreamingInput()) {
                streamMemberDocs = this.getStreamingMemberDocs(opModel.getInputShape());
                docBuilder.append(Constants.LF).append("@param requestBody ").append("The content to send to the service. A {@link RequestBody} can be created using one of ").append("several factory methods for various sources of data. For example, to create a request body ").append("from a file you can do the following. ").append("<pre>{@code RequestBody.of(new File(\"myfile.txt\"))}</pre>").append("See documentation in {@link RequestBody} for additional details and which sources of data ").append("are supported. The service documentation for the request content is as follows '").append((String)streamMemberDocs).append("'.");
            }
            if (opModel.hasStreamingOutput()) {
                streamMemberDocs = this.getStreamingMemberDocs(opModel.getOutputShape());
                docBuilder.append(Constants.LF).append("@param streamingHandler ").append("Functional interface for processing the streamed response content. The unmarshalled ").append(opModel.getOutputShape().getShapeName()).append(" and an InputStream to the response content are provided as parameters to the callback. ").append("The callback may return a transformed type which will be the return value of this method. ").append("See {@link software.amazon.awssdk.runtime.transform.StreamingResponseHandler} for details on ").append("implementing this interface and for links to precanned implementations for common scenarios ").append("like downloading to a file. The service documentation for the response content is as ").append("follows '").append((String)streamMemberDocs).append("'.");
            }
        }
        if (this.returnType != null) {
            docBuilder.append(Constants.LF).append("@return ");
            if (methodType.isAsync()) {
                if (opModel.hasStreamingOutput()) {
                    docBuilder.append("A future to the transformed result of the AsyncResponseHandler.");
                } else {
                    docBuilder.append("A Java Future containing the result of the %s operation returned by the service.".replace("%s", this.operationName));
                }
            } else if (opModel.hasStreamingOutput()) {
                docBuilder.append("The transformed result of the StreamingResponseHandler.");
            } else {
                docBuilder.append("Result of the %s operation returned by the service.".replace("%s", this.operationName));
            }
        }
        if (!methodType.isAsync() && !CollectionUtils.isNullOrEmpty(this.exceptions)) {
            for (ExceptionModel exception : this.exceptions) {
                docBuilder.append(Constants.LF).append("@throws ").append(exception.getExceptionName()).append(" ").append(DocumentationUtils.stripHtmlTags(exception.getDocumentation()));
            }
            docBuilder.append(Constants.LF).append("@throws SdkBaseException Base class for all exceptions that can be thrown ").append("by the SDK (both service and client). Can be used for catch all scenarios.").append(Constants.LF).append("@throws SdkClientException If any client side error occurs such as an IO related ").append("failure, failure to get credentials, etc)").append(Constants.LF).append("@throws ").append(md.getBaseExceptionName()).append(" Base exception for all service exceptions. Unknown exceptions will be thrown as an ").append("instance of this type");
        } else if (methodType.isAsync() && !CollectionUtils.isNullOrEmpty(this.exceptions)) {
            docBuilder.append(Constants.LF).append("<br/>The CompletableFuture returned by this method can be completed exceptionally with the following exceptions.").append("<ul>");
            this.exceptions.forEach(e -> docBuilder.append("\n<li>").append(e.getExceptionName()).append(" ").append(DocumentationUtils.stripHtmlTags(e.getDocumentation())).append("</li>"));
            docBuilder.append("\n<li>SdkBaseException Base class for all exceptions that can be thrown ").append("by the SDK (both service and client). Can be used for catch all scenarios.</li>").append("\n<li>SdkClientException If any client side error occurs ").append("such as an IO related failure, failure to get credentials, etc</li>").append("\n<li>").append(md.getBaseExceptionName()).append(" Base class for all service exceptions. ").append("Unknown exceptions will be thrown as an instance of this </li > ").append("<ul>");
        }
        docBuilder.append(this.getSampleTagForMethodType(methodType, md));
        String crosslink = DocumentationUtils.createLinkToServiceDocumentation(md, this.operationName);
        if (!crosslink.isEmpty()) {
            docBuilder.append(Constants.LF).append(crosslink);
        }
        return docBuilder.toString().replace("$", "&#36;");
    }

    private String getStreamingMemberDocs(ShapeModel streamingShape) {
        return streamingShape.getMembers().stream().filter(m -> m.getHttp().getIsStreaming()).map(DocumentationModel::getDocumentation).findFirst().orElseThrow(() -> new IllegalStateException("Streaming member not found in " + streamingShape.getShapeName()));
    }

    private String getSampleTagForMethodType(MethodType methodType, Metadata md) {
        StringBuilder sb = new StringBuilder();
        sb.append(Constants.LF).append("@sample ");
        if (methodType == MethodType.SYNC) {
            sb.append(md.getSyncInterface());
        } else if (methodType == MethodType.ASYNC) {
            sb.append(md.getAsyncInterface());
        } else if (methodType == MethodType.ASYNC_WITH_HANDLER) {
            sb.append(md.getAsyncInterface() + "Handler");
        }
        sb.append(".").append(this.operationName);
        return sb.toString();
    }

    public VariableModel getInput() {
        return this.input;
    }

    public void setInput(VariableModel input) {
        this.input = input;
    }

    public String getInputStreamPropertyName() {
        return this.inputStreamPropertyName;
    }

    public void setInputStreamPropertyName(String inputStreamPropertyName) {
        this.inputStreamPropertyName = inputStreamPropertyName;
    }

    public ReturnTypeModel getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ReturnTypeModel returnType) {
        this.returnType = returnType;
    }

    private String getBaseReturnType(boolean async) {
        if (this.returnType == null) {
            if (async) {
                return "Void";
            }
            return "void";
        }
        return this.returnType.getReturnType();
    }

    public String getSyncReturnType() {
        return this.getBaseReturnType(false);
    }

    public String getAsyncReturnType() {
        return this.getBaseReturnType(true);
    }

    public String getAsyncFutureType() {
        return "CompletableFuture<" + this.getAsyncReturnType() + ">";
    }

    public String getAsyncCallableType() {
        return "java.util.concurrent.Callable<" + this.getAsyncReturnType() + ">";
    }

    public String getAsyncHandlerType() {
        return "software.amazon.awssdk.handlers.AsyncHandler<" + this.input.getVariableType() + ", " + this.getAsyncReturnType() + ">";
    }

    public List<ExceptionModel> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<ExceptionModel> exceptions) {
        this.exceptions = exceptions;
    }

    public void addException(ExceptionModel exception) {
        this.exceptions.add(exception);
    }

    @JsonIgnore
    public List<SimpleMethodFormModel> getSimpleMethodForms() {
        return this.simpleMethods;
    }

    public void addSimpleMethodForm(List<ArgumentModel> arguments) {
        if (this.simpleMethods == null) {
            this.simpleMethods = new ArrayList<SimpleMethodFormModel>();
        }
        SimpleMethodFormModel form = new SimpleMethodFormModel();
        form.setArguments(arguments);
        this.simpleMethods.add(form);
    }

    public boolean getHasBlobMemberAsPayload() {
        return this.hasBlobMemberAsPayload;
    }

    public void setHasBlobMemberAsPayload(boolean hasBlobMemberAsPayload) {
        this.hasBlobMemberAsPayload = hasBlobMemberAsPayload;
    }

    public boolean hasStreamingInput() {
        return this.inputShape != null && this.inputShape.isHasStreamingMember();
    }

    public boolean hasStreamingOutput() {
        return this.outputShape != null && this.outputShape.isHasStreamingMember();
    }

    private static enum MethodType {
        SYNC(false),
        ASYNC(true),
        ASYNC_WITH_HANDLER(true);

        private final boolean async;

        private MethodType(boolean async) {
            this.async = async;
        }

        public boolean isAsync() {
            return this.async;
        }
    }
}

