/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import software.amazon.awssdk.codegen.emitters.CodeWriter;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.internal.Utils;

public class FreemarkerGeneratorTask
implements GeneratorTask {
    private final Writer writer;
    private final Template template;
    private final Object dataModel;

    public FreemarkerGeneratorTask(String outputDirectory, String fileName, Template template, Object dataModel) throws IOException {
        if (dataModel == null) {
            throw new IllegalArgumentException("Data model cannot be null");
        }
        this.writer = new CodeWriter(outputDirectory, fileName);
        this.template = template;
        this.dataModel = dataModel;
    }

    public FreemarkerGeneratorTask(Writer writer, Template template, Object data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("Data model cannot be null");
        }
        this.writer = writer;
        this.template = template;
        this.dataModel = data;
    }

    @Override
    public void execute() {
        try {
            this.template.process(this.dataModel, this.writer);
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException("Error processing template", e);
        }
        finally {
            Utils.closeQuietly(this.writer);
        }
    }
}

