/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import software.amazon.awssdk.jmespath.Comparator;
import software.amazon.awssdk.jmespath.InvalidTypeException;
import software.amazon.awssdk.jmespath.JmesPathAndExpression;
import software.amazon.awssdk.jmespath.JmesPathField;
import software.amazon.awssdk.jmespath.JmesPathFilter;
import software.amazon.awssdk.jmespath.JmesPathFlatten;
import software.amazon.awssdk.jmespath.JmesPathFunction;
import software.amazon.awssdk.jmespath.JmesPathIdentity;
import software.amazon.awssdk.jmespath.JmesPathLiteral;
import software.amazon.awssdk.jmespath.JmesPathMultiSelectList;
import software.amazon.awssdk.jmespath.JmesPathNotExpression;
import software.amazon.awssdk.jmespath.JmesPathProjection;
import software.amazon.awssdk.jmespath.JmesPathSubExpression;
import software.amazon.awssdk.jmespath.JmesPathValueProjection;
import software.amazon.awssdk.jmespath.JmesPathVisitor;

public class JmesPathCodeGenVisitor
implements JmesPathVisitor<Void, String> {
    public String visit(JmesPathSubExpression subExpression, Void aVoid) throws InvalidTypeException {
        String prefix = "new JmesPathSubExpression( ";
        return subExpression.getExpressions().stream().map(a -> (String)a.accept((JmesPathVisitor)this, (Object)aVoid)).collect(Collectors.joining(",", "new JmesPathSubExpression( ", ")"));
    }

    public String visit(JmesPathField fieldNode, Void aVoid) {
        return "new JmesPathField( \"" + fieldNode.getValue() + "\")";
    }

    public String visit(JmesPathProjection jmesPathProjection, Void aVoid) throws InvalidTypeException {
        String param1 = (String)jmesPathProjection.getLhsExpr().accept((JmesPathVisitor)this, (Object)aVoid);
        String param2 = (String)jmesPathProjection.getProjectionExpr().accept((JmesPathVisitor)this, (Object)aVoid);
        return "new JmesPathProjection( " + param1 + ", " + param2 + ")";
    }

    public String visit(JmesPathFlatten flatten, Void aVoid) throws InvalidTypeException {
        return "new JmesPathFlatten( " + (String)flatten.getFlattenExpr().accept((JmesPathVisitor)this, (Object)aVoid) + ")";
    }

    public String visit(JmesPathIdentity jmesPathIdentity, Void aVoid) {
        return "new JmesPathIdentity()";
    }

    public String visit(JmesPathValueProjection valueProjection, Void aVoid) throws InvalidTypeException {
        String param1 = (String)valueProjection.getLhsExpr().accept((JmesPathVisitor)this, (Object)aVoid);
        String param2 = (String)valueProjection.getRhsExpr().accept((JmesPathVisitor)this, (Object)aVoid);
        return "new JmesPathValueProjection( " + param1 + ", " + param2 + ")";
    }

    public String visit(JmesPathLiteral literal, Void aVoid) {
        return "new JmesPathLiteral(\"" + StringEscapeUtils.escapeJava((String)literal.getValue().toString()) + "\")";
    }

    public String visit(JmesPathFilter filter, Void aVoid) throws InvalidTypeException {
        return "new JmesPathFilter( " + (String)filter.getLhsExpr().accept((JmesPathVisitor)this, (Object)aVoid) + ", " + (String)filter.getRhsExpr().accept((JmesPathVisitor)this, (Object)aVoid) + ", " + (String)filter.getComparator().accept((JmesPathVisitor)this, (Object)aVoid) + ")";
    }

    public String visit(JmesPathFunction function, Void aVoid) throws InvalidTypeException {
        String prefix = "new " + function.getClass().getSimpleName() + "( ";
        return function.getExpressions().stream().map(a -> (String)a.accept((JmesPathVisitor)this, (Object)aVoid)).collect(Collectors.joining(",", prefix, ")"));
    }

    public String visit(Comparator op, Void aVoid) throws InvalidTypeException {
        String lhs = (String)op.getLhsExpr().accept((JmesPathVisitor)this, (Object)aVoid);
        String rhs = (String)op.getRhsExpr().accept((JmesPathVisitor)this, (Object)aVoid);
        return String.format("new %s(%s, %s)", op.getClass().getSimpleName(), lhs, rhs);
    }

    public String visit(JmesPathNotExpression notExpression, Void aVoid) throws InvalidTypeException {
        return "new JmesPathNotExpression( " + (String)notExpression.getExpr().accept((JmesPathVisitor)this, (Object)aVoid) + " )";
    }

    public String visit(JmesPathAndExpression andExpression, Void aVoid) throws InvalidTypeException {
        String param1 = (String)andExpression.getLhsExpr().accept((JmesPathVisitor)this, (Object)aVoid);
        String param2 = (String)andExpression.getRhsExpr().accept((JmesPathVisitor)this, (Object)aVoid);
        return "new JmesPathAndExpression( " + param1 + ", " + param2 + " )";
    }

    public String visit(JmesPathMultiSelectList multiSelectList, Void aVoid) throws InvalidTypeException {
        String prefix = "new JmesPathMultiSelectList( ";
        return multiSelectList.getExpressions().stream().map(a -> (String)a.accept((JmesPathVisitor)this, (Object)aVoid)).collect(Collectors.joining(",", "new JmesPathMultiSelectList( ", ")"));
    }
}

