/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;

public interface ProtocolSpec {
    public FieldSpec protocolFactory(IntermediateModel var1);

    public MethodSpec initProtocolFactory(IntermediateModel var1);

    public CodeBlock responseHandler(IntermediateModel var1, OperationModel var2);

    public CodeBlock errorResponseHandler(OperationModel var1);

    public CodeBlock executionHandler(OperationModel var1);

    default public CodeBlock asyncExecutionHandler(IntermediateModel intermediateModel, OperationModel opModel) {
        return this.executionHandler(opModel);
    }

    default public Class<? extends SyncClientHandler> getClientHandlerClass() {
        return AwsSyncClientHandler.class;
    }

    public Optional<MethodSpec> createErrorResponseHandler();

    default public List<MethodSpec> additionalMethods() {
        return new ArrayList<MethodSpec>();
    }

    default public List<CodeBlock> registerModeledExceptions(IntermediateModel model, PoetExtensions poetExtensions) {
        return model.getShapes().values().stream().filter(s -> s.getShapeType() == ShapeType.Exception).map(e -> CodeBlock.builder().add(".registerModeledException($T.builder().errorCode($S).exceptionBuilderSupplier($T::builder)$L.build())", new Object[]{ExceptionMetadata.class, e.getErrorCode(), poetExtensions.getModelClass(e.getShapeName()), this.populateHttpStatusCode((ShapeModel)e)}).build()).collect(Collectors.toList());
    }

    default public String populateHttpStatusCode(ShapeModel shapeModel) {
        return shapeModel.getHttpStatusCode() != null ? String.format(".httpStatusCode(%d)", shapeModel.getHttpStatusCode()) : "";
    }
}

