/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetCollectors;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.utils.ToString;

public class ModelMethodOverrides {
    private final PoetExtensions poetExtensions;

    public ModelMethodOverrides(PoetExtensions poetExtensions) {
        this.poetExtensions = poetExtensions;
    }

    public MethodSpec equalsMethod(ShapeModel shapeModel) {
        ClassName className = this.poetExtensions.getModelClass(shapeModel.getShapeName());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"equals").returns(Boolean.TYPE).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Object.class, "obj", new Modifier[0]).beginControlFlow("if (this == obj)", new Object[0]).addStatement("return true", new Object[0]).endControlFlow().beginControlFlow("if (obj == null)", new Object[0]).addStatement("return false", new Object[0]).endControlFlow().beginControlFlow("if (!(obj instanceof $T))", new Object[]{className}).addStatement("return false", new Object[0]).endControlFlow();
        if (!shapeModel.getNonStreamingMembers().isEmpty()) {
            methodBuilder.addStatement("$T other = ($T) obj", new Object[]{className, className});
        }
        List<MemberModel> memberModels = shapeModel.getNonStreamingMembers();
        CodeBlock.Builder memberEqualsStmt = CodeBlock.builder();
        if (memberModels.isEmpty()) {
            memberEqualsStmt.addStatement("return true", new Object[0]);
        } else {
            memberEqualsStmt.add("return ", new Object[0]);
            memberEqualsStmt.add(memberModels.stream().map(m -> {
                String getterName = m.getFluentGetterMethodName();
                return CodeBlock.builder().add("$T.equals($N(), other.$N())", new Object[]{Objects.class, getterName, getterName}).build();
            }).collect(PoetCollectors.toDelimitedCodeBlock("&&")));
            memberEqualsStmt.add(";", new Object[0]);
        }
        return methodBuilder.addCode(memberEqualsStmt.build()).build();
    }

    public MethodSpec toStringMethod(ShapeModel shapeModel) {
        MethodSpec.Builder toStringMethod = MethodSpec.methodBuilder((String)"toString").returns(String.class).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        toStringMethod.addCode("return $T.builder($S)", new Object[]{ToString.class, shapeModel.getShapeName()});
        shapeModel.getNonStreamingMembers().forEach(m -> toStringMethod.addCode(".add($S, $N())", new Object[]{m.getName(), m.getFluentGetterMethodName()}));
        toStringMethod.addCode(".build();", new Object[0]);
        return toStringMethod.build();
    }

    public MethodSpec hashCodeMethod(ShapeModel shapeModel) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"hashCode").returns(Integer.TYPE).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("int hashCode = 1", new Object[0]);
        shapeModel.getNonStreamingMembers().forEach(m -> methodBuilder.addStatement("hashCode = 31 * hashCode + $T.hashCode($N())", new Object[]{Objects.class, m.getFluentGetterMethodName()}));
        methodBuilder.addStatement("return hashCode", new Object[0]);
        return methodBuilder.build();
    }
}

