/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.Optional;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.utils.Validate;

final class ClientClassUtils {
    private static final String PAGINATOR_USER_AGENT = "PAGINATED";

    private ClientClassUtils() {
    }

    static Optional<CodeBlock> getCustomResponseHandler(OperationModel operationModel, ClassName returnType) {
        Optional<CodeBlock> customUnmarshaller = Optional.ofNullable(operationModel.getOutputShape()).map(ShapeModel::getCustomization).flatMap(c -> Optional.ofNullable(c.getCustomUnmarshallerFqcn()));
        return customUnmarshaller.map(unmarshaller -> {
            if (operationModel.hasStreamingOutput()) {
                throw new UnsupportedOperationException("Custom unmarshallers cannot be applied to streaming operations yet.");
            }
            return CodeBlock.builder().add("$T<$T> responseHandler = (response, __) -> new $T().unmarshall(response);", new Object[]{HttpResponseHandler.class, returnType, ClassName.bestGuess((String)unmarshaller)}).build();
        });
    }

    static MethodSpec consumerBuilderVariant(MethodSpec spec, String javadoc) {
        Validate.validState((spec.parameters.size() > 0 ? 1 : 0) != 0, (String)"A first parameter is required to generate a consumer-builder method.", (Object[])new Object[0]);
        Validate.validState((boolean)(((ParameterSpec)spec.parameters.get((int)0)).type instanceof ClassName), (String)"The first parameter must be a class.", (Object[])new Object[0]);
        ParameterSpec firstParameter = (ParameterSpec)spec.parameters.get(0);
        ClassName firstParameterClass = (ClassName)firstParameter.type;
        ParameterizedTypeName consumer = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{firstParameterClass.nestedClass("Builder")});
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)spec.name).returns(spec.returnType).addExceptions((Iterable)spec.exceptions).addJavadoc(javadoc, new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addTypeVariables((Iterable)spec.typeVariables).addParameter(ParameterSpec.builder((TypeName)consumer, (String)firstParameter.name, (Modifier[])new Modifier[0]).build());
        StringBuilder methodBody = new StringBuilder("return $L($T.builder().applyMutation($L).build()");
        for (int i = 1; i < spec.parameters.size(); ++i) {
            ParameterSpec parameter = (ParameterSpec)spec.parameters.get(i);
            methodBody.append(", ").append(parameter.name);
            result.addParameter(parameter);
        }
        methodBody.append(")");
        result.addStatement(methodBody.toString(), new Object[]{spec.name, firstParameterClass, firstParameter.name});
        return result.build();
    }

    static MethodSpec applyPaginatorUserAgentMethod(PoetExtensions poetExtensions, IntermediateModel model) {
        TypeVariableName typeVariableName = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{poetExtensions.getModelClass(model.getSdkRequestBaseClassName())});
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{ClassName.get(AwsRequestOverrideConfiguration.Builder.class)});
        CodeBlock codeBlock = CodeBlock.builder().addStatement("$T userAgentApplier = b -> b.addApiName($T.builder().version($T.SDK_VERSION).name($S).build())", new Object[]{parameterizedTypeName, ApiName.class, VersionInfo.class, PAGINATOR_USER_AGENT}).addStatement("$T overrideConfiguration =\n            request.overrideConfiguration().map(c -> c.toBuilder().applyMutation(userAgentApplier).build())\n            .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()))", new Object[]{AwsRequestOverrideConfiguration.class}).addStatement("return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build()", new Object[0]).build();
        return MethodSpec.methodBuilder((String)"applyPaginatorUserAgent").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)typeVariableName, "request", new Modifier[0]).addTypeVariable(typeVariableName).addCode(codeBlock).returns((TypeName)typeVariableName).build();
    }

    static MethodSpec applySignerOverrideMethod(PoetExtensions poetExtensions, IntermediateModel model) {
        String signerOverrideVariable = "signerOverride";
        TypeVariableName typeVariableName = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{poetExtensions.getModelClass(model.getSdkRequestBaseClassName())});
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{ClassName.get(AwsRequestOverrideConfiguration.Builder.class)});
        CodeBlock codeBlock = CodeBlock.builder().beginControlFlow("if (request.overrideConfiguration().flatMap(c -> c.signer()).isPresent())", new Object[0]).addStatement("return request", new Object[0]).endControlFlow().addStatement("$T $L = b -> b.signer(signer).build()", new Object[]{parameterizedTypeName, "signerOverride"}).addStatement("$1T overrideConfiguration =\n            request.overrideConfiguration().map(c -> c.toBuilder().applyMutation($2L).build())\n            .orElse((AwsRequestOverrideConfiguration.builder().applyMutation($2L).build()))", new Object[]{AwsRequestOverrideConfiguration.class, "signerOverride"}).addStatement("return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build()", new Object[0]).build();
        return MethodSpec.methodBuilder((String)"applySignerOverride").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)typeVariableName, "request", new Modifier[0]).addParameter(Signer.class, "signer", new Modifier[0]).addTypeVariable(typeVariableName).addCode(codeBlock).returns((TypeName)typeVariableName).build();
    }

    static CodeBlock callApplySignerOverrideMethod(OperationModel opModel) {
        CodeBlock.Builder code = CodeBlock.builder();
        ShapeModel inputShape = opModel.getInputShape();
        if (inputShape.getRequestSignerClassFqcn() != null) {
            try {
                code.addStatement("$1L = applySignerOverride($1L, $2T.create())", new Object[]{opModel.getInput().getVariableName(), Class.forName(inputShape.getRequestSignerClassFqcn())});
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return code.build();
    }
}

