/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.SyncClientClass;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;

public final class AsyncClientClass
extends AsyncClientInterface {
    private final PoetExtensions poetExtensions;
    private final ClassName className;
    private final ProtocolSpec protocolSpec;
    private final String basePackage;

    public AsyncClientClass(GeneratorTaskParams dependencies) {
        super(dependencies.getModel());
        this.poetExtensions = dependencies.getPoetExtensions();
        this.className = this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncClient());
        this.protocolSpec = SyncClientClass.getProtocolSpecs(this.poetExtensions, this.model.getMetadata().getProtocol());
        this.basePackage = dependencies.getModel().getMetadata().getFullClientPackageName();
    }

    @Override
    public TypeSpec poetSpec() {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface());
        TypeSpec.Builder classBuilder = PoetUtils.createClassBuilder(this.className).addAnnotation(SdkInternalApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addField(AsyncClientHandler.class, "clientHandler", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(this.protocolSpec.protocolFactory(this.model)).addSuperinterface((TypeName)interfaceClass).addJavadoc("Internal implementation of {@link $1T}.\n\n@see $1T#builder()", new Object[]{interfaceClass}).addMethod(this.constructor()).addMethods(this.operations()).addMethod(this.closeMethod()).addMethods(this.protocolSpec.additionalMethods()).addMethod(this.protocolSpec.initProtocolFactory(this.model));
        this.protocolSpec.createErrorResponseHandler().ifPresent(arg_0 -> ((TypeSpec.Builder)classBuilder).addMethod(arg_0));
        if (this.model.getCustomizationConfig().getServiceSpecificClientConfigClass() != null) {
            classBuilder.addMethod(this.constructorWithAdvancedConfiguration());
        }
        return classBuilder.build();
    }

    private MethodSpec constructor() {
        if (this.model.getCustomizationConfig().getServiceSpecificClientConfigClass() != null) {
            return MethodSpec.constructorBuilder().addParameter(AwsAsyncClientParams.class, "asyncClientParams", new Modifier[0]).addStatement("this($N, null)", new Object[]{"asyncClientParams"}).build();
        }
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(AwsAsyncClientParams.class, "clientParams", new Modifier[0]).addStatement("this.$N = new $T(new $T()\n.withAsyncClientParams($N)\n.withClientParams($N)\n.withCalculateCrc32FromCompressedDataEnabled($L))", new Object[]{"clientHandler", SdkAsyncClientHandler.class, ClientHandlerParams.class, "clientParams", "clientParams", this.model.getCustomizationConfig().isCalculateCrc32FromCompressedData()}).addStatement("this.$N = init()", new Object[]{this.protocolSpec.protocolFactory((IntermediateModel)this.model).name}).build();
    }

    private MethodSpec constructorWithAdvancedConfiguration() {
        ClassName advancedConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceSpecificClientConfigClass(), (String[])new String[0]);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(AwsAsyncClientParams.class, "clientParams", new Modifier[0]).addParameter((TypeName)advancedConfiguration, "advancedConfiguration", new Modifier[0]).addStatement("this.$N = new $T(new $T()\n.withAsyncClientParams($N)\n.withClientParams($N)\n.withCalculateCrc32FromCompressedDataEnabled($L).withServiceAdvancedConfiguration(advancedConfiguration))", new Object[]{"clientHandler", SdkAsyncClientHandler.class, ClientHandlerParams.class, "clientParams", "clientParams", this.model.getCustomizationConfig().isCalculateCrc32FromCompressedData()}).addStatement("this.$N = init()", new Object[]{this.protocolSpec.protocolFactory((IntermediateModel)this.model).name}).build();
    }

    private MethodSpec closeMethod() {
        return MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addException(Exception.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$N.close()", new Object[]{"clientHandler"}).build();
    }

    @Override
    protected MethodSpec.Builder operationBody(MethodSpec.Builder builder, OperationModel opModel) {
        return builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(this.protocolSpec.asyncResponseHandler(opModel)).addCode(this.protocolSpec.errorResponseHandler(opModel)).addCode(this.protocolSpec.asyncExecutionHandler(opModel));
    }

    @Override
    public ClassName className() {
        return this.className;
    }
}

