/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringEscapeUtils;
import software.amazon.awssdk.codegen.JmesPathCodeGenVisitor;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.jmespath.JmesPathExpression;
import software.amazon.awssdk.jmespath.JmesPathVisitor;
import software.amazon.awssdk.utils.StringUtils;

public class AcceptorModel {
    private String matcher;
    private String argument;
    private String state;
    private JsonNode expected;
    private JmesPathExpression ast;

    public String getAst() {
        if (this.ast != null) {
            return (String)this.ast.accept((JmesPathVisitor)new JmesPathCodeGenVisitor(), null);
        }
        return null;
    }

    public void setAst(JmesPathExpression ast) {
        this.ast = ast;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String matcher) {
        this.matcher = matcher;
    }

    public String getArgument() {
        return this.argument;
    }

    public void setArgument(String argument) {
        this.argument = argument;
    }

    public JsonNode getExpected() {
        return this.expected;
    }

    public void setExpected(JsonNode expected) {
        this.expected = expected;
    }

    public String getExpectedAsCamelCase() {
        return Utils.capitialize(this.expected.asText().replaceAll("\\W", ""));
    }

    public String getExpectedAsEscapedJson() {
        return StringEscapeUtils.escapeJava((String)this.expected.toString());
    }

    public String getExpectedAsString() {
        if (this.expected.isTextual()) {
            return this.expected.toString();
        }
        return null;
    }

    public BigDecimal getExpectedAsNumber() {
        if (this.expected.isNumber()) {
            return this.expected.decimalValue();
        }
        return null;
    }

    public String getEnumState() {
        return "WaiterState." + StringUtils.upperCase((String)this.state);
    }

    public boolean getIsStatusMatcher() {
        return this.matcher.equals("status");
    }

    public boolean getIsErrorMatcher() {
        return this.matcher.equals("error");
    }
}

