/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.awssdk.codegen.AddCustomAuthorizers;
import software.amazon.awssdk.codegen.AddEmptyInputShape;
import software.amazon.awssdk.codegen.AddEmptyOutputShape;
import software.amazon.awssdk.codegen.AddExceptionShapes;
import software.amazon.awssdk.codegen.AddInputShapes;
import software.amazon.awssdk.codegen.AddMetadata;
import software.amazon.awssdk.codegen.AddModelShapes;
import software.amazon.awssdk.codegen.AddOperations;
import software.amazon.awssdk.codegen.AddOutputShapes;
import software.amazon.awssdk.codegen.AddWaiters;
import software.amazon.awssdk.codegen.C2jModels;
import software.amazon.awssdk.codegen.ExamplesCustomizer;
import software.amazon.awssdk.codegen.IntermediateModelShapeProcessor;
import software.amazon.awssdk.codegen.RemoveUnusedShapes;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.customization.processors.DefaultCustomizationProcessor;
import software.amazon.awssdk.codegen.internal.TypeUtils;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.BasicCodeGenConfig;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.AuthorizerModel;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ServiceExamples;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.WaiterDefinitionModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Waiters;
import software.amazon.awssdk.codegen.naming.DefaultNamingStrategy;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.utils.Logger;

public class IntermediateModelBuilder {
    private static final Logger log = Logger.loggerFor(IntermediateModelBuilder.class);
    private final CustomizationConfig customConfig;
    private final BasicCodeGenConfig codeGenConfig;
    private final ServiceModel service;
    private final ServiceExamples examples;
    private final NamingStrategy namingStrategy;
    private final TypeUtils typeUtils;
    private final List<IntermediateModelShapeProcessor> shapeProcessors;
    private final Waiters waiters;

    public IntermediateModelBuilder(C2jModels models) {
        this.customConfig = models.customizationConfig();
        this.codeGenConfig = models.codeGenConfig();
        this.service = models.serviceModel();
        this.examples = models.examplesModel();
        this.namingStrategy = new DefaultNamingStrategy(this.service, this.customConfig);
        this.typeUtils = new TypeUtils(this.namingStrategy);
        this.shapeProcessors = this.createShapeProcessors();
        this.waiters = models.waitersModel();
    }

    private List<IntermediateModelShapeProcessor> createShapeProcessors() {
        ArrayList<IntermediateModelShapeProcessor> processors = new ArrayList<IntermediateModelShapeProcessor>();
        processors.add(new AddInputShapes(this));
        processors.add(new AddOutputShapes(this));
        processors.add(new AddExceptionShapes(this));
        processors.add(new AddModelShapes(this));
        processors.add(new AddEmptyInputShape(this));
        processors.add(new AddEmptyOutputShape(this));
        return processors;
    }

    public IntermediateModel build() throws IOException {
        log.info(() -> "Applying customizations to examples...");
        new ExamplesCustomizer(this.service, this.customConfig).applyCustomizationsToExamples(this.examples);
        log.info(() -> "Examples customized.");
        CodegenCustomizationProcessor customization = DefaultCustomizationProcessor.getProcessorFor(this.customConfig);
        customization.preprocess(this.service);
        TreeMap<String, OperationModel> operations = new TreeMap<String, OperationModel>();
        HashMap<String, ShapeModel> shapes = new HashMap<String, ShapeModel>();
        HashMap<String, WaiterDefinitionModel> waiters = new HashMap<String, WaiterDefinitionModel>();
        HashMap<String, AuthorizerModel> authorizers = new HashMap<String, AuthorizerModel>();
        operations.putAll(new AddOperations(this).constructOperations());
        waiters.putAll(new AddWaiters(this.waiters, operations).constructWaiters());
        authorizers.putAll(new AddCustomAuthorizers(this.service, this.getNamingStrategy()).constructAuthorizers());
        for (IntermediateModelShapeProcessor processor : this.shapeProcessors) {
            shapes.putAll(processor.process(Collections.unmodifiableMap(operations), Collections.unmodifiableMap(shapes)));
        }
        log.info(() -> shapes.size() + " shapes found in total.");
        IntermediateModel fullModel = new IntermediateModel(AddMetadata.constructMetadata(this.service, this.codeGenConfig, this.customConfig), operations, shapes, this.customConfig, this.examples, waiters, authorizers);
        customization.postprocess(fullModel);
        log.info(() -> fullModel.getShapes().size() + " shapes remained after applying customizations.");
        Map<String, ShapeModel> trimmedShapes = RemoveUnusedShapes.removeUnusedShapes(fullModel);
        log.info(() -> trimmedShapes.size() + " shapes remained after removing unused shapes.");
        IntermediateModel trimmedModel = new IntermediateModel(fullModel.getMetadata(), fullModel.getOperations(), trimmedShapes, fullModel.getCustomizationConfig(), fullModel.getExamples(), fullModel.getWaiters(), fullModel.getCustomAuthorizers());
        this.linkMembersToShapes(trimmedModel);
        this.linkOperationsToInputOutputShapes(trimmedModel);
        this.linkCustomAuthorizationToRequestShapes(trimmedModel);
        return trimmedModel;
    }

    private void linkMembersToShapes(IntermediateModel model) {
        for (Map.Entry<String, ShapeModel> entry : model.getShapes().entrySet()) {
            if (entry.getValue().getMembers() == null) continue;
            for (MemberModel member : entry.getValue().getMembers()) {
                member.setShape(Utils.findShapeModelByC2jNameIfExists(model, member.getC2jShape()));
            }
        }
    }

    private void linkOperationsToInputOutputShapes(IntermediateModel model) {
        for (Map.Entry<String, OperationModel> entry : model.getOperations().entrySet()) {
            Operation operation = this.service.getOperations().get(entry.getKey());
            if (entry.getValue().getInput() != null) {
                entry.getValue().setInputShape(model.getShapes().get(entry.getValue().getInput().getSimpleType()));
            }
            if (operation.getOutput() == null) continue;
            String outputShapeName = operation.getOutput().getShape();
            if (!StringUtils.isNullOrEmpty((String)operation.getOutput().getResultWrapper())) continue;
            entry.getValue().setOutputShape(model.getShapeByC2jName(outputShapeName));
        }
    }

    private void linkCustomAuthorizationToRequestShapes(IntermediateModel model) {
        if (model.getMetadata().getProtocol() != Protocol.API_GATEWAY) {
            return;
        }
        model.getOperations().values().stream().filter(OperationModel::isAuthenticated).forEach(operation -> {
            Operation c2jOperation = this.service.getOperation(operation.getOperationName());
            ShapeModel shape = operation.getInputShape();
            if (shape == null) {
                throw new RuntimeException(String.format("Operation %s has unknown input shape", operation.getOperationName()));
            }
            if (AuthType.CUSTOM.equals((Object)c2jOperation.getAuthType())) {
                AuthorizerModel auth = model.getCustomAuthorizers().get(c2jOperation.getAuthorizer());
                if (auth == null) {
                    throw new RuntimeException(String.format("Required custom auth not defined: %s", c2jOperation.getAuthorizer()));
                }
                shape.setRequestSignerClassFqcn(model.getMetadata().getAuthPolicyPackageName() + '.' + auth.getInterfaceName());
            } else if (AuthType.IAM.equals((Object)c2jOperation.getAuthType())) {
                model.getMetadata().setRequiresIamSigners(true);
                shape.setRequestSignerClassFqcn("software.amazon.awssdk.opensdk.protect.auth.IamRequestSigner");
            }
        });
    }

    public CustomizationConfig getCustomConfig() {
        return this.customConfig;
    }

    public BasicCodeGenConfig codeGenConfig() {
        return this.codeGenConfig;
    }

    public ServiceModel getService() {
        return this.service;
    }

    public ServiceExamples getExamples() {
        return this.examples;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public TypeUtils getTypeUtils() {
        return this.typeUtils;
    }
}

