/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import software.amazon.awssdk.codegen.C2jModels;
import software.amazon.awssdk.codegen.CodeGenerator;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.rules.endpoints.EndpointTestSuiteModel;
import software.amazon.awssdk.codegen.model.service.EndpointRuleSetModel;
import software.amazon.awssdk.codegen.model.service.Paginators;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Waiters;
import software.amazon.awssdk.codegen.utils.ModelLoaderUtils;

@Mojo(name="generate")
public class GenerationMojo
extends AbstractMojo {
    private static final String MODEL_FILE = "service-2.json";
    private static final String CUSTOMIZATION_CONFIG_FILE = "customization.config";
    private static final String WAITERS_FILE = "waiters-2.json";
    private static final String PAGINATORS_FILE = "paginators-1.json";
    private static final String ENDPOINT_RULE_SET_FILE = "endpoint-rule-set.json";
    private static final String ENDPOINT_TESTS_FILE = "endpoint-tests.json";
    @Parameter(property="codeGenResources", defaultValue="${basedir}/src/main/resources/codegen-resources/")
    private File codeGenResources;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}")
    private String outputDirectory;
    @Parameter(property="writeIntermediateModel", defaultValue="false")
    private boolean writeIntermediateModel;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    private Path sourcesDirectory;
    private Path resourcesDirectory;
    private Path testsDirectory;

    public void execute() throws MojoExecutionException {
        this.sourcesDirectory = Paths.get(this.outputDirectory, new String[0]).resolve("generated-sources").resolve("sdk");
        this.resourcesDirectory = Paths.get(this.outputDirectory, new String[0]).resolve("generated-resources").resolve("sdk-resources");
        this.testsDirectory = Paths.get(this.outputDirectory, new String[0]).resolve("generated-test-sources").resolve("sdk-tests");
        this.findModelRoots().forEach(p -> {
            Path modelRootPath = ((ModelRoot)p).modelRoot;
            this.getLog().info((CharSequence)("Loading from: " + modelRootPath.toString()));
            this.generateCode(C2jModels.builder().customizationConfig(((ModelRoot)p).customizationConfig).serviceModel(this.loadServiceModel(modelRootPath)).waitersModel(this.loadWaiterModel(modelRootPath)).paginatorsModel(this.loadPaginatorModel(modelRootPath)).endpointRuleSetModel(this.loadEndpointRuleSetModel(modelRootPath)).endpointTestSuiteModel(this.loadEndpointTestSuiteModel(modelRootPath)).build());
        });
        this.project.addCompileSourceRoot(this.sourcesDirectory.toFile().getAbsolutePath());
        this.project.addTestCompileSourceRoot(this.testsDirectory.toFile().getAbsolutePath());
    }

    private Stream<ModelRoot> findModelRoots() throws MojoExecutionException {
        try {
            return Files.find(this.codeGenResources.toPath(), 10, this::isModelFile, new FileVisitOption[0]).map(Path::getParent).map(p -> new ModelRoot((Path)p, this.loadCustomizationConfig((Path)p))).sorted(this::modelSharersLast);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to find 'service-2.json' files in " + this.codeGenResources, (Exception)e);
        }
    }

    private int modelSharersLast(ModelRoot lhs, ModelRoot rhs) {
        return lhs.customizationConfig.getShareModelConfig() == null ? -1 : 1;
    }

    private boolean isModelFile(Path p, BasicFileAttributes a) {
        return p.toString().endsWith(MODEL_FILE);
    }

    private void generateCode(C2jModels models) {
        CodeGenerator.builder().models(models).sourcesDirectory(this.sourcesDirectory.toFile().getAbsolutePath()).resourcesDirectory(this.resourcesDirectory.toFile().getAbsolutePath()).testsDirectory(this.testsDirectory.toFile().getAbsolutePath()).intermediateModelFileNamePrefix(this.intermediateModelFileNamePrefix(models)).build().execute();
    }

    private String intermediateModelFileNamePrefix(C2jModels models) {
        return this.writeIntermediateModel ? Utils.getFileNamePrefix((ServiceModel)models.serviceModel()) : null;
    }

    private CustomizationConfig loadCustomizationConfig(Path root) {
        return ModelLoaderUtils.loadOptionalModel(CustomizationConfig.class, (File)root.resolve(CUSTOMIZATION_CONFIG_FILE).toFile(), (boolean)true).orElse(CustomizationConfig.create());
    }

    private ServiceModel loadServiceModel(Path root) {
        return this.loadRequiredModel(ServiceModel.class, root.resolve(MODEL_FILE));
    }

    private Waiters loadWaiterModel(Path root) {
        return this.loadOptionalModel(Waiters.class, root.resolve(WAITERS_FILE)).orElse(Waiters.none());
    }

    private Paginators loadPaginatorModel(Path root) {
        return this.loadOptionalModel(Paginators.class, root.resolve(PAGINATORS_FILE)).orElse(Paginators.none());
    }

    private EndpointRuleSetModel loadEndpointRuleSetModel(Path root) {
        return this.loadOptionalModel(EndpointRuleSetModel.class, root.resolve(ENDPOINT_RULE_SET_FILE)).orElse(null);
    }

    private EndpointTestSuiteModel loadEndpointTestSuiteModel(Path root) {
        return this.loadOptionalModel(EndpointTestSuiteModel.class, root.resolve(ENDPOINT_TESTS_FILE)).orElse(null);
    }

    private <T> T loadRequiredModel(Class<T> clzz, Path location) {
        return (T)ModelLoaderUtils.loadModel(clzz, (File)location.toFile());
    }

    private <T> Optional<T> loadOptionalModel(Class<T> clzz, Path location) {
        return ModelLoaderUtils.loadOptionalModel(clzz, (File)location.toFile());
    }

    private static class ModelRoot {
        private final Path modelRoot;
        private final CustomizationConfig customizationConfig;

        private ModelRoot(Path modelRoot, CustomizationConfig customizationConfig) {
            this.modelRoot = modelRoot;
            this.customizationConfig = customizationConfig;
        }
    }
}

