/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.defaultsmode;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Locale;
import java.util.Map;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.defaultsmode.DefaultConfiguration;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.internal.EnumUtils;

public class DefaultsModeGenerator
implements PoetClass {
    private static final String VALUE = "value";
    private static final String VALUE_MAP = "VALUE_MAP";
    private final String basePackage;
    private final DefaultConfiguration configuration;

    public DefaultsModeGenerator(String basePackage, DefaultConfiguration configuration) {
        this.basePackage = basePackage;
        this.configuration = configuration;
    }

    @Override
    public TypeSpec poetClass() {
        TypeSpec.Builder builder = TypeSpec.enumBuilder((ClassName)this.className()).addField(this.valueMapField()).addField(String.class, VALUE, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(this.documentation()).addAnnotation(SdkPublicApi.class).addAnnotation(AnnotationSpec.builder(Generated.class).addMember(VALUE, "$S", new Object[]{"software.amazon.awssdk:codegen"}).build()).addMethod(this.fromValueSpec()).addMethod(DefaultsModeGenerator.toStringBuilder().addStatement("return $T.valueOf($N)", new Object[]{String.class, VALUE}).build()).addMethod(this.createConstructor());
        builder.addEnumConstant("LEGACY", this.enumValueTypeSpec("legacy", this.javaDocForMode("legacy")));
        this.configuration.modeDefaults().keySet().forEach(k -> {
            String enumKey = this.sanitizeEnum((String)k);
            builder.addEnumConstant(enumKey, this.enumValueTypeSpec((String)k, this.javaDocForMode((String)k)));
        });
        builder.addEnumConstant("AUTO", this.enumValueTypeSpec("auto", this.javaDocForMode("auto")));
        return builder.build();
    }

    @Override
    public ClassName className() {
        return ClassName.get((String)this.basePackage, (String)"DefaultsMode", (String[])new String[0]);
    }

    private TypeSpec enumValueTypeSpec(String value, String documentation) {
        return TypeSpec.anonymousClassBuilder((String)"$S", (Object[])new Object[]{value}).addJavadoc(documentation, new Object[0]).build();
    }

    private FieldSpec valueMapField() {
        ParameterizedTypeName mapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), this.className()});
        return FieldSpec.builder((TypeName)mapType, (String)VALUE_MAP, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$1T.uniqueIndex($2T.class, $2T::toString)", new Object[]{EnumUtils.class, this.className()}).build();
    }

    private String sanitizeEnum(String str) {
        return str.replace('-', '_').toUpperCase(Locale.US);
    }

    private String javaDocForMode(String mode) {
        return this.configuration.modesDocumentation().getOrDefault(mode, "");
    }

    private CodeBlock documentation() {
        CodeBlock.Builder builder = CodeBlock.builder().add("A defaults mode determines how certain default configuration options are resolved in the SDK. Based on the provided mode, the SDK will vend sensible default values tailored to the mode for the following settings:", new Object[0]).add(System.lineSeparator(), new Object[0]);
        builder.add("<ul>", new Object[0]);
        this.configuration.configurationDocumentation().forEach((k, v) -> builder.add("<li>" + k + ": " + v + "</li>", new Object[0]));
        builder.add("</ul>", new Object[0]).add(System.lineSeparator(), new Object[0]);
        builder.add("<p>All options above can be configured by users, and the overridden value will take precedence.", new Object[0]).add("<p><b>Note:</b> for any mode other than {@link #LEGACY}, the vended default values might change as best practices may evolve. As a result, it is encouraged to perform testing when upgrading the SDK if you are using a mode other than {@link #LEGACY}", new Object[0]).add(System.lineSeparator(), new Object[0]);
        return builder.add("<p>While the {@link #LEGACY} defaults mode is specific to Java, other modes are standardized across all of the AWS SDKs</p>", new Object[0]).add(System.lineSeparator(), new Object[0]).add("<p>The defaults mode can be configured:", new Object[0]).add(System.lineSeparator(), new Object[0]).add("<ol>", new Object[0]).add("<li>Directly on a client via {@code AwsClientBuilder.Builder#defaultsMode(DefaultsMode)}.</li>", new Object[0]).add(System.lineSeparator(), new Object[0]).add("<li>On a configuration profile via the \"defaults_mode\" profile file property.</li>", new Object[0]).add(System.lineSeparator(), new Object[0]).add("<li>Globally via the \"aws.defaultsMode\" system property.</li>", new Object[0]).add("<li>Globally via the \"AWS_DEFAULTS_MODE\" environment variable.</li>", new Object[0]).add("</ol>", new Object[0]).build();
    }

    private MethodSpec fromValueSpec() {
        return MethodSpec.methodBuilder((String)"fromValue").returns((TypeName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("Use this in place of valueOf to convert the raw string returned by the service into the enum value.\n\n@param $N real value\n@return $T corresponding to the value\n", new Object[]{VALUE, this.className()}).addParameter(String.class, VALUE, new Modifier[0]).addStatement("$T.paramNotNull(value, $S)", new Object[]{Validate.class, VALUE}).beginControlFlow("if (!VALUE_MAP.containsKey(value))", new Object[0]).addStatement("throw new IllegalArgumentException($S + value)", new Object[]{"The provided value is not a valid defaults mode "}).endControlFlow().addStatement("return $N.get($N)", new Object[]{VALUE_MAP, VALUE}).build();
    }

    private MethodSpec createConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(String.class, VALUE, new Modifier[0]).addStatement("this.$1N = $1N", new Object[]{VALUE}).build();
    }

    private static MethodSpec.Builder toStringBuilder() {
        return MethodSpec.methodBuilder((String)"toString").returns(String.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class);
    }
}

