/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.Utils;
import software.amazon.awssdk.codegen.lite.regions.model.Partition;

public class RegionMetadataGenerator
implements PoetClass {
    private final Partition partition;
    private final String region;
    private final String regionDescription;
    private final String basePackage;
    private final String regionBasePackage;

    public RegionMetadataGenerator(Partition partition, String region, String regionDescription, String basePackage, String regionBasePackage) {
        this.partition = partition;
        this.region = region;
        this.regionDescription = regionDescription;
        this.basePackage = basePackage;
        this.regionBasePackage = regionBasePackage;
    }

    @Override
    public TypeSpec poetClass() {
        return TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"software.amazon.awssdk:codegen"}).build()).addAnnotation(SdkPublicApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface((TypeName)ClassName.get((String)this.regionBasePackage, (String)"RegionMetadata", (String[])new String[0])).addField(this.staticFinalField("ID", this.region)).addField(this.staticFinalField("DOMAIN", this.partition.getDnsSuffix())).addField(this.staticFinalField("DESCRIPTION", this.regionDescription)).addField(this.staticFinalField("PARTITION_ID", this.partition.getPartition())).addMethod(this.getter("id", "ID")).addMethod(this.getter("domain", "DOMAIN")).addMethod(this.getter("description", "DESCRIPTION")).addMethod(this.partition()).build();
    }

    private MethodSpec partition() {
        ClassName regionMetadataClass = ClassName.get((String)"software.amazon.awssdk.regions", (String)"PartitionMetadata", (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"partition").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)regionMetadataClass).addStatement("return $T.of(PARTITION_ID)", new Object[]{regionMetadataClass}).build();
    }

    @Override
    public ClassName className() {
        return ClassName.get((String)this.basePackage, (String)Stream.of(this.region.split("-")).map(Utils::capitalize).collect(Collectors.joining()), (String[])new String[0]);
    }

    private FieldSpec staticFinalField(String fieldName, String fieldValue) {
        return FieldSpec.builder(String.class, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{fieldValue}).build();
    }

    private MethodSpec getter(String getterName, String fieldName) {
        return MethodSpec.methodBuilder((String)getterName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $L", new Object[]{fieldName.toUpperCase(Locale.US)}).build();
    }
}

