/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.Utils;
import software.amazon.awssdk.codegen.lite.regions.model.Partition;

public class PartitionMetadataGenerator
implements PoetClass {
    private final Partition partition;
    private final String basePackage;
    private final String regionBasePackage;

    public PartitionMetadataGenerator(Partition partition, String basePackage, String regionBasePackage) {
        this.partition = partition;
        this.basePackage = basePackage;
        this.regionBasePackage = regionBasePackage;
    }

    @Override
    public TypeSpec poetClass() {
        return TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get((String)this.regionBasePackage, (String)"PartitionMetadata", (String[])new String[0])).addAnnotation(SdkPublicApi.class).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"software.amazon.awssdk:codegen"}).build()).addField(FieldSpec.builder(String.class, (String)"DNS_SUFFIX", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.partition.getDnsSuffix()}).build()).addField(FieldSpec.builder(String.class, (String)"HOSTNAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.partition.getDefaults().getHostname()}).build()).addField(FieldSpec.builder(String.class, (String)"ID", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.partition.getPartition()}).build()).addField(FieldSpec.builder(String.class, (String)"NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.partition.getPartitionName()}).build()).addField(FieldSpec.builder(String.class, (String)"REGION_REGEX", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.partition.getRegionRegex()}).build()).addMethod(this.getter("dnsSuffix", "DNS_SUFFIX")).addMethod(this.getter("hostname", "HOSTNAME")).addMethod(this.getter("id", "ID")).addMethod(this.getter("name", "NAME")).addMethod(this.getter("regionRegex", "REGION_REGEX")).build();
    }

    @Override
    public ClassName className() {
        return ClassName.get((String)this.basePackage, (String)(Stream.of(this.partition.getPartition().split("-")).map(Utils::capitalize).collect(Collectors.joining()) + "PartitionMetadata"), (String[])new String[0]);
    }

    private MethodSpec getter(String methodName, String field) {
        return MethodSpec.methodBuilder((String)methodName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $L", new Object[]{field}).build();
    }
}

