/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions;

import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class RegionValidationUtil {
    private static final String FIPS_SUFFIX = "-fips";
    private static final String FIPS_PREFIX = "fips-";

    private RegionValidationUtil() {
    }

    public static boolean validRegion(String region, String regex) {
        return RegionValidationUtil.matchesRegex(region, regex) || RegionValidationUtil.matchesRegexFipsSuffix(region, regex) || RegionValidationUtil.matchesRegexFipsPrefix(region, regex) || RegionValidationUtil.isGlobal(region);
    }

    private static boolean matchesRegex(String region, String regex) {
        return region.matches(regex);
    }

    private static boolean matchesRegexFipsSuffix(String region, String regex) {
        return region.replace(FIPS_SUFFIX, "").matches(regex);
    }

    private static boolean matchesRegexFipsPrefix(String region, String regex) {
        return region.replace(FIPS_PREFIX, "").matches(regex);
    }

    private static boolean isGlobal(String region) {
        return region.contains("global");
    }
}

