/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.NestedContainersRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link NestedContainersRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class NestedContainersRequestModelMarshaller {
    private static final MarshallingInfo<List> LISTOFLISTOFSTRINGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListOfListOfStrings").isBinary(false).build();

    private static final MarshallingInfo<List> LISTOFLISTOFLISTOFSTRINGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListOfListOfListOfStrings").isBinary(false).build();

    private static final MarshallingInfo<Map> MAPOFSTRINGTOLISTOFLISTOFSTRINGS_BINDING = MarshallingInfo
            .builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("MapOfStringToListOfListOfStrings").isBinary(false).build();

    private static final NestedContainersRequestModelMarshaller INSTANCE = new NestedContainersRequestModelMarshaller();

    private NestedContainersRequestModelMarshaller() {
    }

    public static NestedContainersRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(NestedContainersRequest nestedContainersRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(nestedContainersRequest, "nestedContainersRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(nestedContainersRequest.listOfListOfStrings(), LISTOFLISTOFSTRINGS_BINDING);
            protocolMarshaller.marshall(nestedContainersRequest.listOfListOfListOfStrings(), LISTOFLISTOFLISTOFSTRINGS_BINDING);
            protocolMarshaller.marshall(nestedContainersRequest.mapOfStringToListOfListOfStrings(),
                    MAPOFSTRINGTOLISTOFLISTOFSTRINGS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
